/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.models.ProviderOperation;
import java.io.IOException;
import java.util.List;

public final class ResourceType
implements JsonSerializable<ResourceType> {
    private String name;
    private String displayName;
    private List<ProviderOperation> operations;

    public String name() {
        return this.name;
    }

    public ResourceType withName(String name) {
        this.name = name;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public ResourceType withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public List<ProviderOperation> operations() {
        return this.operations;
    }

    public ResourceType withOperations(List<ProviderOperation> operations) {
        this.operations = operations;
        return this;
    }

    public void validate() {
        if (this.operations() != null) {
            this.operations().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeArrayField("operations", this.operations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ResourceType fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceType)jsonReader.readObject(reader -> {
            ResourceType deserializedResourceType = new ResourceType();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedResourceType.name = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedResourceType.displayName = reader.getString();
                    continue;
                }
                if ("operations".equals(fieldName)) {
                    List operations;
                    deserializedResourceType.operations = operations = reader.readArray(reader1 -> ProviderOperation.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceType;
        });
    }
}

