/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.models.PolicyProperties;
import com.azure.resourcemanager.authorization.models.Principal;
import com.azure.resourcemanager.authorization.models.RoleManagementPolicyRule;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class RoleManagementPolicyProperties
implements JsonSerializable<RoleManagementPolicyProperties> {
    private String scope;
    private String displayName;
    private String description;
    private Boolean isOrganizationDefault;
    private Principal lastModifiedBy;
    private OffsetDateTime lastModifiedDateTime;
    private List<RoleManagementPolicyRule> rules;
    private List<RoleManagementPolicyRule> effectiveRules;
    private PolicyProperties policyProperties;

    public String scope() {
        return this.scope;
    }

    public RoleManagementPolicyProperties withScope(String scope) {
        this.scope = scope;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public RoleManagementPolicyProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String description() {
        return this.description;
    }

    public RoleManagementPolicyProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public Boolean isOrganizationDefault() {
        return this.isOrganizationDefault;
    }

    public RoleManagementPolicyProperties withIsOrganizationDefault(Boolean isOrganizationDefault) {
        this.isOrganizationDefault = isOrganizationDefault;
        return this;
    }

    public Principal lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public OffsetDateTime lastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public List<RoleManagementPolicyRule> rules() {
        return this.rules;
    }

    public RoleManagementPolicyProperties withRules(List<RoleManagementPolicyRule> rules) {
        this.rules = rules;
        return this;
    }

    public List<RoleManagementPolicyRule> effectiveRules() {
        return this.effectiveRules;
    }

    public PolicyProperties policyProperties() {
        return this.policyProperties;
    }

    public void validate() {
        if (this.lastModifiedBy() != null) {
            this.lastModifiedBy().validate();
        }
        if (this.rules() != null) {
            this.rules().forEach(e -> e.validate());
        }
        if (this.effectiveRules() != null) {
            this.effectiveRules().forEach(e -> e.validate());
        }
        if (this.policyProperties() != null) {
            this.policyProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("scope", this.scope);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeBooleanField("isOrganizationDefault", this.isOrganizationDefault);
        jsonWriter.writeArrayField("rules", this.rules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static RoleManagementPolicyProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RoleManagementPolicyProperties)jsonReader.readObject(reader -> {
            RoleManagementPolicyProperties deserializedRoleManagementPolicyProperties = new RoleManagementPolicyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("scope".equals(fieldName)) {
                    deserializedRoleManagementPolicyProperties.scope = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedRoleManagementPolicyProperties.displayName = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedRoleManagementPolicyProperties.description = reader.getString();
                    continue;
                }
                if ("isOrganizationDefault".equals(fieldName)) {
                    deserializedRoleManagementPolicyProperties.isOrganizationDefault = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    deserializedRoleManagementPolicyProperties.lastModifiedBy = Principal.fromJson(reader);
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedRoleManagementPolicyProperties.lastModifiedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("rules".equals(fieldName)) {
                    List rules;
                    deserializedRoleManagementPolicyProperties.rules = rules = reader.readArray(reader1 -> RoleManagementPolicyRule.fromJson(reader1));
                    continue;
                }
                if ("effectiveRules".equals(fieldName)) {
                    List effectiveRules;
                    deserializedRoleManagementPolicyProperties.effectiveRules = effectiveRules = reader.readArray(reader1 -> RoleManagementPolicyRule.fromJson(reader1));
                    continue;
                }
                if ("policyProperties".equals(fieldName)) {
                    deserializedRoleManagementPolicyProperties.policyProperties = PolicyProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRoleManagementPolicyProperties;
        });
    }
}

