/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.RoleAssignmentProperties;
import com.azure.resourcemanager.authorization.models.PrincipalType;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class RoleAssignmentInner
extends ProxyResource {
    private RoleAssignmentProperties innerProperties;
    private String id;
    private String name;
    private String type;

    private RoleAssignmentProperties innerProperties() {
        return this.innerProperties;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public String scope() {
        return this.innerProperties() == null ? null : this.innerProperties().scope();
    }

    public String roleDefinitionId() {
        return this.innerProperties() == null ? null : this.innerProperties().roleDefinitionId();
    }

    public RoleAssignmentInner withRoleDefinitionId(String roleDefinitionId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleAssignmentProperties();
        }
        this.innerProperties().withRoleDefinitionId(roleDefinitionId);
        return this;
    }

    public String principalId() {
        return this.innerProperties() == null ? null : this.innerProperties().principalId();
    }

    public RoleAssignmentInner withPrincipalId(String principalId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleAssignmentProperties();
        }
        this.innerProperties().withPrincipalId(principalId);
        return this;
    }

    public PrincipalType principalType() {
        return this.innerProperties() == null ? null : this.innerProperties().principalType();
    }

    public RoleAssignmentInner withPrincipalType(PrincipalType principalType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleAssignmentProperties();
        }
        this.innerProperties().withPrincipalType(principalType);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public RoleAssignmentInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleAssignmentProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public String condition() {
        return this.innerProperties() == null ? null : this.innerProperties().condition();
    }

    public RoleAssignmentInner withCondition(String condition) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleAssignmentProperties();
        }
        this.innerProperties().withCondition(condition);
        return this;
    }

    public String conditionVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().conditionVersion();
    }

    public RoleAssignmentInner withConditionVersion(String conditionVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleAssignmentProperties();
        }
        this.innerProperties().withConditionVersion(conditionVersion);
        return this;
    }

    public OffsetDateTime createdOn() {
        return this.innerProperties() == null ? null : this.innerProperties().createdOn();
    }

    public OffsetDateTime updatedOn() {
        return this.innerProperties() == null ? null : this.innerProperties().updatedOn();
    }

    public String createdBy() {
        return this.innerProperties() == null ? null : this.innerProperties().createdBy();
    }

    public String updatedBy() {
        return this.innerProperties() == null ? null : this.innerProperties().updatedBy();
    }

    public String delegatedManagedIdentityResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().delegatedManagedIdentityResourceId();
    }

    public RoleAssignmentInner withDelegatedManagedIdentityResourceId(String delegatedManagedIdentityResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleAssignmentProperties();
        }
        this.innerProperties().withDelegatedManagedIdentityResourceId(delegatedManagedIdentityResourceId);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static RoleAssignmentInner fromJson(JsonReader jsonReader) throws IOException {
        return (RoleAssignmentInner)((Object)jsonReader.readObject(reader -> {
            RoleAssignmentInner deserializedRoleAssignmentInner = new RoleAssignmentInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedRoleAssignmentInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRoleAssignmentInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRoleAssignmentInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedRoleAssignmentInner.innerProperties = RoleAssignmentProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRoleAssignmentInner;
        }));
    }
}

