/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphIdentitySet;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphItemReference;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphUserInner;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

public class MicrosoftGraphBaseItemInner
extends MicrosoftGraphEntity {
    private MicrosoftGraphIdentitySet createdBy;
    private OffsetDateTime createdDateTime;
    private String description;
    private String etag;
    private MicrosoftGraphIdentitySet lastModifiedBy;
    private OffsetDateTime lastModifiedDateTime;
    private String name;
    private MicrosoftGraphItemReference parentReference;
    private String webUrl;
    private MicrosoftGraphUserInner createdByUser;
    private MicrosoftGraphUserInner lastModifiedByUser;
    private Map<String, Object> additionalProperties;

    public MicrosoftGraphIdentitySet createdBy() {
        return this.createdBy;
    }

    public MicrosoftGraphBaseItemInner withCreatedBy(MicrosoftGraphIdentitySet createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    public OffsetDateTime createdDateTime() {
        return this.createdDateTime;
    }

    public MicrosoftGraphBaseItemInner withCreatedDateTime(OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    public String description() {
        return this.description;
    }

    public MicrosoftGraphBaseItemInner withDescription(String description) {
        this.description = description;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public MicrosoftGraphBaseItemInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public MicrosoftGraphIdentitySet lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public MicrosoftGraphBaseItemInner withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
        return this;
    }

    public OffsetDateTime lastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public MicrosoftGraphBaseItemInner withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
        return this;
    }

    public String name() {
        return this.name;
    }

    public MicrosoftGraphBaseItemInner withName(String name) {
        this.name = name;
        return this;
    }

    public MicrosoftGraphItemReference parentReference() {
        return this.parentReference;
    }

    public MicrosoftGraphBaseItemInner withParentReference(MicrosoftGraphItemReference parentReference) {
        this.parentReference = parentReference;
        return this;
    }

    public String webUrl() {
        return this.webUrl;
    }

    public MicrosoftGraphBaseItemInner withWebUrl(String webUrl) {
        this.webUrl = webUrl;
        return this;
    }

    public MicrosoftGraphUserInner createdByUser() {
        return this.createdByUser;
    }

    public MicrosoftGraphBaseItemInner withCreatedByUser(MicrosoftGraphUserInner createdByUser) {
        this.createdByUser = createdByUser;
        return this;
    }

    public MicrosoftGraphUserInner lastModifiedByUser() {
        return this.lastModifiedByUser;
    }

    public MicrosoftGraphBaseItemInner withLastModifiedByUser(MicrosoftGraphUserInner lastModifiedByUser) {
        this.lastModifiedByUser = lastModifiedByUser;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphBaseItemInner withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphBaseItemInner withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.createdBy() != null) {
            this.createdBy().validate();
        }
        if (this.lastModifiedBy() != null) {
            this.lastModifiedBy().validate();
        }
        if (this.parentReference() != null) {
            this.parentReference().validate();
        }
        if (this.createdByUser() != null) {
            this.createdByUser().validate();
        }
        if (this.lastModifiedByUser() != null) {
            this.lastModifiedByUser().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("createdBy", (JsonSerializable)this.createdBy);
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("eTag", this.etag);
        jsonWriter.writeJsonField("lastModifiedBy", (JsonSerializable)this.lastModifiedBy);
        jsonWriter.writeStringField("lastModifiedDateTime", this.lastModifiedDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime));
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("parentReference", (JsonSerializable)this.parentReference);
        jsonWriter.writeStringField("webUrl", this.webUrl);
        jsonWriter.writeJsonField("createdByUser", (JsonSerializable)this.createdByUser);
        jsonWriter.writeJsonField("lastModifiedByUser", (JsonSerializable)this.lastModifiedByUser);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphBaseItemInner fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphBaseItemInner)jsonReader.readObject(reader -> {
            MicrosoftGraphBaseItemInner deserializedMicrosoftGraphBaseItemInner = new MicrosoftGraphBaseItemInner();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphBaseItemInner.withId(reader.getString());
                    continue;
                }
                if ("createdBy".equals(fieldName)) {
                    deserializedMicrosoftGraphBaseItemInner.createdBy = MicrosoftGraphIdentitySet.fromJson(reader);
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphBaseItemInner.createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedMicrosoftGraphBaseItemInner.description = reader.getString();
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedMicrosoftGraphBaseItemInner.etag = reader.getString();
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    deserializedMicrosoftGraphBaseItemInner.lastModifiedBy = MicrosoftGraphIdentitySet.fromJson(reader);
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphBaseItemInner.lastModifiedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMicrosoftGraphBaseItemInner.name = reader.getString();
                    continue;
                }
                if ("parentReference".equals(fieldName)) {
                    deserializedMicrosoftGraphBaseItemInner.parentReference = MicrosoftGraphItemReference.fromJson(reader);
                    continue;
                }
                if ("webUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphBaseItemInner.webUrl = reader.getString();
                    continue;
                }
                if ("createdByUser".equals(fieldName)) {
                    deserializedMicrosoftGraphBaseItemInner.createdByUser = MicrosoftGraphUserInner.fromJson(reader);
                    continue;
                }
                if ("lastModifiedByUser".equals(fieldName)) {
                    deserializedMicrosoftGraphBaseItemInner.lastModifiedByUser = MicrosoftGraphUserInner.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphBaseItemInner.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphBaseItemInner;
        });
    }
}

