/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphAutomaticRepliesStatus;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDateTimeZone;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphExternalAudienceScope;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MicrosoftGraphAutomaticRepliesSetting
implements JsonSerializable<MicrosoftGraphAutomaticRepliesSetting> {
    private MicrosoftGraphExternalAudienceScope externalAudience;
    private String externalReplyMessage;
    private String internalReplyMessage;
    private MicrosoftGraphDateTimeZone scheduledEndDateTime;
    private MicrosoftGraphDateTimeZone scheduledStartDateTime;
    private MicrosoftGraphAutomaticRepliesStatus status;
    private Map<String, Object> additionalProperties;

    public MicrosoftGraphExternalAudienceScope externalAudience() {
        return this.externalAudience;
    }

    public MicrosoftGraphAutomaticRepliesSetting withExternalAudience(MicrosoftGraphExternalAudienceScope externalAudience) {
        this.externalAudience = externalAudience;
        return this;
    }

    public String externalReplyMessage() {
        return this.externalReplyMessage;
    }

    public MicrosoftGraphAutomaticRepliesSetting withExternalReplyMessage(String externalReplyMessage) {
        this.externalReplyMessage = externalReplyMessage;
        return this;
    }

    public String internalReplyMessage() {
        return this.internalReplyMessage;
    }

    public MicrosoftGraphAutomaticRepliesSetting withInternalReplyMessage(String internalReplyMessage) {
        this.internalReplyMessage = internalReplyMessage;
        return this;
    }

    public MicrosoftGraphDateTimeZone scheduledEndDateTime() {
        return this.scheduledEndDateTime;
    }

    public MicrosoftGraphAutomaticRepliesSetting withScheduledEndDateTime(MicrosoftGraphDateTimeZone scheduledEndDateTime) {
        this.scheduledEndDateTime = scheduledEndDateTime;
        return this;
    }

    public MicrosoftGraphDateTimeZone scheduledStartDateTime() {
        return this.scheduledStartDateTime;
    }

    public MicrosoftGraphAutomaticRepliesSetting withScheduledStartDateTime(MicrosoftGraphDateTimeZone scheduledStartDateTime) {
        this.scheduledStartDateTime = scheduledStartDateTime;
        return this;
    }

    public MicrosoftGraphAutomaticRepliesStatus status() {
        return this.status;
    }

    public MicrosoftGraphAutomaticRepliesSetting withStatus(MicrosoftGraphAutomaticRepliesStatus status) {
        this.status = status;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public MicrosoftGraphAutomaticRepliesSetting withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
        if (this.scheduledEndDateTime() != null) {
            this.scheduledEndDateTime().validate();
        }
        if (this.scheduledStartDateTime() != null) {
            this.scheduledStartDateTime().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("externalAudience", this.externalAudience == null ? null : this.externalAudience.toString());
        jsonWriter.writeStringField("externalReplyMessage", this.externalReplyMessage);
        jsonWriter.writeStringField("internalReplyMessage", this.internalReplyMessage);
        jsonWriter.writeJsonField("scheduledEndDateTime", (JsonSerializable)this.scheduledEndDateTime);
        jsonWriter.writeJsonField("scheduledStartDateTime", (JsonSerializable)this.scheduledStartDateTime);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphAutomaticRepliesSetting fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphAutomaticRepliesSetting)jsonReader.readObject(reader -> {
            MicrosoftGraphAutomaticRepliesSetting deserializedMicrosoftGraphAutomaticRepliesSetting = new MicrosoftGraphAutomaticRepliesSetting();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("externalAudience".equals(fieldName)) {
                    deserializedMicrosoftGraphAutomaticRepliesSetting.externalAudience = MicrosoftGraphExternalAudienceScope.fromString(reader.getString());
                    continue;
                }
                if ("externalReplyMessage".equals(fieldName)) {
                    deserializedMicrosoftGraphAutomaticRepliesSetting.externalReplyMessage = reader.getString();
                    continue;
                }
                if ("internalReplyMessage".equals(fieldName)) {
                    deserializedMicrosoftGraphAutomaticRepliesSetting.internalReplyMessage = reader.getString();
                    continue;
                }
                if ("scheduledEndDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphAutomaticRepliesSetting.scheduledEndDateTime = MicrosoftGraphDateTimeZone.fromJson(reader);
                    continue;
                }
                if ("scheduledStartDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphAutomaticRepliesSetting.scheduledStartDateTime = MicrosoftGraphDateTimeZone.fromJson(reader);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedMicrosoftGraphAutomaticRepliesSetting.status = MicrosoftGraphAutomaticRepliesStatus.fromString(reader.getString());
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphAutomaticRepliesSetting.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphAutomaticRepliesSetting;
        });
    }
}

