/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.ServicePrincipalsClient;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphKeyCredentialInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphPasswordCredentialInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalsAddKeyRequestBodyInner;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalsAddPasswordRequestBodyInner;
import com.azure.resourcemanager.authorization.implementation.MicrosoftGraphClientImpl;
import reactor.core.publisher.Mono;

public final class ServicePrincipalsClientImpl
implements ServicePrincipalsClient {
    private final ServicePrincipalsService service;
    private final MicrosoftGraphClientImpl client;

    ServicePrincipalsClientImpl(MicrosoftGraphClientImpl client) {
        this.service = (ServicePrincipalsService)RestProxy.create(ServicePrincipalsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphKeyCredentialInner>> addKeyWithResponseAsync(String servicePrincipalId, ServicePrincipalsAddKeyRequestBodyInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.addKey(this.client.getEndpoint(), servicePrincipalId, body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphKeyCredentialInner>> addKeyWithResponseAsync(String servicePrincipalId, ServicePrincipalsAddKeyRequestBodyInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.addKey(this.client.getEndpoint(), servicePrincipalId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphKeyCredentialInner> addKeyAsync(String servicePrincipalId, ServicePrincipalsAddKeyRequestBodyInner body) {
        return this.addKeyWithResponseAsync(servicePrincipalId, body).flatMap(res -> Mono.justOrEmpty((Object)((MicrosoftGraphKeyCredentialInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphKeyCredentialInner> addKeyWithResponse(String servicePrincipalId, ServicePrincipalsAddKeyRequestBodyInner body, Context context) {
        return (Response)this.addKeyWithResponseAsync(servicePrincipalId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphKeyCredentialInner addKey(String servicePrincipalId, ServicePrincipalsAddKeyRequestBodyInner body) {
        return (MicrosoftGraphKeyCredentialInner)this.addKeyWithResponse(servicePrincipalId, body, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphPasswordCredentialInner>> addPasswordWithResponseAsync(String servicePrincipalId, ServicePrincipalsAddPasswordRequestBodyInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.addPassword(this.client.getEndpoint(), servicePrincipalId, body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphPasswordCredentialInner>> addPasswordWithResponseAsync(String servicePrincipalId, ServicePrincipalsAddPasswordRequestBodyInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.addPassword(this.client.getEndpoint(), servicePrincipalId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphPasswordCredentialInner> addPasswordAsync(String servicePrincipalId, ServicePrincipalsAddPasswordRequestBodyInner body) {
        return this.addPasswordWithResponseAsync(servicePrincipalId, body).flatMap(res -> Mono.justOrEmpty((Object)((MicrosoftGraphPasswordCredentialInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphPasswordCredentialInner> addPasswordWithResponse(String servicePrincipalId, ServicePrincipalsAddPasswordRequestBodyInner body, Context context) {
        return (Response)this.addPasswordWithResponseAsync(servicePrincipalId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphPasswordCredentialInner addPassword(String servicePrincipalId, ServicePrincipalsAddPasswordRequestBodyInner body) {
        return (MicrosoftGraphPasswordCredentialInner)this.addPasswordWithResponse(servicePrincipalId, body, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MicrosoftGraphClient")
    public static interface ServicePrincipalsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/servicePrincipals/{servicePrincipal-id}/microsoft.graph.addKey")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphKeyCredentialInner>> addKey(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @BodyParam(value="application/json") ServicePrincipalsAddKeyRequestBodyInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/servicePrincipals/{servicePrincipal-id}/microsoft.graph.addPassword")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphPasswordCredentialInner>> addPassword(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @BodyParam(value="application/json") ServicePrincipalsAddPasswordRequestBodyInner var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

