/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOnenoteOperationError;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOperation;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOperationStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MicrosoftGraphOnenoteOperation
extends MicrosoftGraphOperation {
    private MicrosoftGraphOnenoteOperationError error;
    private String percentComplete;
    private String resourceId;
    private String resourceLocation;
    private Map<String, Object> additionalProperties;

    public MicrosoftGraphOnenoteOperationError error() {
        return this.error;
    }

    public MicrosoftGraphOnenoteOperation withError(MicrosoftGraphOnenoteOperationError error) {
        this.error = error;
        return this;
    }

    public String percentComplete() {
        return this.percentComplete;
    }

    public MicrosoftGraphOnenoteOperation withPercentComplete(String percentComplete) {
        this.percentComplete = percentComplete;
        return this;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public MicrosoftGraphOnenoteOperation withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public String resourceLocation() {
        return this.resourceLocation;
    }

    public MicrosoftGraphOnenoteOperation withResourceLocation(String resourceLocation) {
        this.resourceLocation = resourceLocation;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphOnenoteOperation withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphOnenoteOperation withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphOnenoteOperation withLastActionDateTime(OffsetDateTime lastActionDateTime) {
        super.withLastActionDateTime(lastActionDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphOnenoteOperation withStatus(MicrosoftGraphOperationStatus status) {
        super.withStatus(status);
        return this;
    }

    @Override
    public MicrosoftGraphOnenoteOperation withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.error() != null) {
            this.error().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime()));
        jsonWriter.writeStringField("lastActionDateTime", this.lastActionDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastActionDateTime()));
        jsonWriter.writeStringField("status", this.status() == null ? null : this.status().toString());
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        jsonWriter.writeStringField("percentComplete", this.percentComplete);
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("resourceLocation", this.resourceLocation);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphOnenoteOperation fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphOnenoteOperation)jsonReader.readObject(reader -> {
            MicrosoftGraphOnenoteOperation deserializedMicrosoftGraphOnenoteOperation = new MicrosoftGraphOnenoteOperation();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteOperation.withId(reader.getString());
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteOperation.withCreatedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("lastActionDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteOperation.withLastActionDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteOperation.withStatus(MicrosoftGraphOperationStatus.fromString(reader.getString()));
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteOperation.error = MicrosoftGraphOnenoteOperationError.fromJson(reader);
                    continue;
                }
                if ("percentComplete".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteOperation.percentComplete = reader.getString();
                    continue;
                }
                if ("resourceId".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteOperation.resourceId = reader.getString();
                    continue;
                }
                if ("resourceLocation".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteOperation.resourceLocation = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphOnenoteOperation.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphOnenoteOperation;
        });
    }
}

