/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.UsersSettingsClient;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphShiftPreferencesInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.azure.resourcemanager.authorization.fluent.models.UsersSettingsSelect;
import com.azure.resourcemanager.authorization.implementation.MicrosoftGraphClientImpl;
import java.util.List;
import reactor.core.publisher.Mono;

public final class UsersSettingsClientImpl
implements UsersSettingsClient {
    private final ClientLogger logger = new ClientLogger(UsersSettingsClientImpl.class);
    private final UsersSettingsService service;
    private final MicrosoftGraphClientImpl client;

    UsersSettingsClientImpl(MicrosoftGraphClientImpl client) {
        this.service = (UsersSettingsService)RestProxy.create(UsersSettingsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<MicrosoftGraphShiftPreferencesInner>> getShiftPreferencesWithResponseAsync(String userId, List<UsersSettingsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getShiftPreferences(this.client.getEndpoint(), userId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphShiftPreferencesInner>> getShiftPreferencesWithResponseAsync(String userId, List<UsersSettingsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getShiftPreferences(this.client.getEndpoint(), userId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphShiftPreferencesInner> getShiftPreferencesAsync(String userId, List<UsersSettingsSelect> select, List<String> expand) {
        return this.getShiftPreferencesWithResponseAsync(userId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphShiftPreferencesInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<MicrosoftGraphShiftPreferencesInner> getShiftPreferencesAsync(String userId) {
        List<UsersSettingsSelect> select = null;
        List<String> expand = null;
        return this.getShiftPreferencesWithResponseAsync(userId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphShiftPreferencesInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphShiftPreferencesInner getShiftPreferences(String userId) {
        List<UsersSettingsSelect> select = null;
        List<String> expand = null;
        return (MicrosoftGraphShiftPreferencesInner)this.getShiftPreferencesAsync(userId, select, expand).block();
    }

    @Override
    public Response<MicrosoftGraphShiftPreferencesInner> getShiftPreferencesWithResponse(String userId, List<UsersSettingsSelect> select, List<String> expand, Context context) {
        return (Response)this.getShiftPreferencesWithResponseAsync(userId, select, expand, context).block();
    }

    @Override
    public Mono<Response<Void>> updateShiftPreferencesWithResponseAsync(String userId, MicrosoftGraphShiftPreferencesInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateShiftPreferences(this.client.getEndpoint(), userId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> updateShiftPreferencesWithResponseAsync(String userId, MicrosoftGraphShiftPreferencesInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateShiftPreferences(this.client.getEndpoint(), userId, body, "application/json", context);
    }

    @Override
    public Mono<Void> updateShiftPreferencesAsync(String userId, MicrosoftGraphShiftPreferencesInner body) {
        return this.updateShiftPreferencesWithResponseAsync(userId, body).flatMap(res -> Mono.empty());
    }

    @Override
    public void updateShiftPreferences(String userId, MicrosoftGraphShiftPreferencesInner body) {
        this.updateShiftPreferencesAsync(userId, body).block();
    }

    @Override
    public Response<Void> updateShiftPreferencesWithResponse(String userId, MicrosoftGraphShiftPreferencesInner body, Context context) {
        return (Response)this.updateShiftPreferencesWithResponseAsync(userId, body, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteShiftPreferencesWithResponseAsync(String userId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteShiftPreferences(this.client.getEndpoint(), userId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteShiftPreferencesWithResponseAsync(String userId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteShiftPreferences(this.client.getEndpoint(), userId, ifMatch, "application/json", context);
    }

    @Override
    public Mono<Void> deleteShiftPreferencesAsync(String userId, String ifMatch) {
        return this.deleteShiftPreferencesWithResponseAsync(userId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public Mono<Void> deleteShiftPreferencesAsync(String userId) {
        String ifMatch = null;
        return this.deleteShiftPreferencesWithResponseAsync(userId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public void deleteShiftPreferences(String userId) {
        String ifMatch = null;
        this.deleteShiftPreferencesAsync(userId, ifMatch).block();
    }

    @Override
    public Response<Void> deleteShiftPreferencesWithResponse(String userId, String ifMatch, Context context) {
        return (Response)this.deleteShiftPreferencesWithResponseAsync(userId, ifMatch, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MicrosoftGraphClient")
    private static interface UsersSettingsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/settings/shiftPreferences")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphShiftPreferencesInner>> getShiftPreferences(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @QueryParam(value="$select") String var3, @QueryParam(value="$expand") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/users/{user-id}/settings/shiftPreferences")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateShiftPreferences(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @BodyParam(value="application/json") MicrosoftGraphShiftPreferencesInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/users/{user-id}/settings/shiftPreferences")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteShiftPreferences(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @HeaderParam(value="If-Match") String var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

