/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.RoleAssignmentsClient;
import com.azure.resourcemanager.authorization.fluent.models.RoleAssignmentInner;
import com.azure.resourcemanager.authorization.implementation.AuthorizationManagementClientImpl;
import com.azure.resourcemanager.authorization.models.RoleAssignmentCreateParameters;
import com.azure.resourcemanager.authorization.models.RoleAssignmentListResult;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import reactor.core.publisher.Mono;

public final class RoleAssignmentsClientImpl
implements InnerSupportsListing<RoleAssignmentInner>,
InnerSupportsDelete<RoleAssignmentInner>,
RoleAssignmentsClient {
    private final ClientLogger logger = new ClientLogger(RoleAssignmentsClientImpl.class);
    private final RoleAssignmentsService service;
    private final AuthorizationManagementClientImpl client;

    RoleAssignmentsClientImpl(AuthorizationManagementClientImpl client) {
        this.service = (RoleAssignmentsService)RestProxy.create(RoleAssignmentsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<RoleAssignmentInner>> listForResourceSinglePageAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (parentResourcePath == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2018-01-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listForResource(this.client.getEndpoint(), resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, filter, "2018-01-01-preview", this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).value(), ((RoleAssignmentListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<RoleAssignmentInner>> listForResourceSinglePageAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (parentResourcePath == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2018-01-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listForResource(this.client.getEndpoint(), resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, filter, "2018-01-01-preview", this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).value(), ((RoleAssignmentListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<RoleAssignmentInner> listForResourceAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String filter) {
        return new PagedFlux(() -> this.listForResourceSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, filter), nextLink -> this.listForResourceNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<RoleAssignmentInner> listForResourceAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName) {
        String filter = null;
        return new PagedFlux(() -> this.listForResourceSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, filter), nextLink -> this.listForResourceNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<RoleAssignmentInner> listForResourceAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String filter, Context context) {
        return new PagedFlux(() -> this.listForResourceSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, filter, context), nextLink -> this.listForResourceNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<RoleAssignmentInner> listForResource(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName) {
        String filter = null;
        return new PagedIterable(this.listForResourceAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, filter));
    }

    @Override
    public PagedIterable<RoleAssignmentInner> listForResource(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String filter, Context context) {
        return new PagedIterable(this.listForResourceAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, filter, context));
    }

    private Mono<PagedResponse<RoleAssignmentInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2018-01-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, filter, "2018-01-01-preview", this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).value(), ((RoleAssignmentListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<RoleAssignmentInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2018-01-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, filter, "2018-01-01-preview", this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).value(), ((RoleAssignmentListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<RoleAssignmentInner> listByResourceGroupAsync(String resourceGroupName, String filter) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, filter), nextLink -> this.listForResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<RoleAssignmentInner> listByResourceGroupAsync(String resourceGroupName) {
        String filter = null;
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, filter), nextLink -> this.listForResourceGroupNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<RoleAssignmentInner> listByResourceGroupAsync(String resourceGroupName, String filter, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, filter, context), nextLink -> this.listForResourceGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<RoleAssignmentInner> listByResourceGroup(String resourceGroupName) {
        String filter = null;
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, filter));
    }

    @Override
    public PagedIterable<RoleAssignmentInner> listByResourceGroup(String resourceGroupName, String filter, Context context) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, filter, context));
    }

    @Override
    public Mono<Response<RoleAssignmentInner>> deleteWithResponseAsync(String scope, String roleAssignmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleAssignmentName is required and cannot be null."));
        }
        String apiVersion = "2018-01-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), scope, roleAssignmentName, "2018-01-01-preview", "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<RoleAssignmentInner>> deleteWithResponseAsync(String scope, String roleAssignmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleAssignmentName is required and cannot be null."));
        }
        String apiVersion = "2018-01-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), scope, roleAssignmentName, "2018-01-01-preview", "application/json", context);
    }

    @Override
    public Mono<RoleAssignmentInner> deleteAsync(String scope, String roleAssignmentName) {
        return this.deleteWithResponseAsync(scope, roleAssignmentName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((RoleAssignmentInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public RoleAssignmentInner delete(String scope, String roleAssignmentName) {
        return (RoleAssignmentInner)this.deleteAsync(scope, roleAssignmentName).block();
    }

    @Override
    public Response<RoleAssignmentInner> deleteWithResponse(String scope, String roleAssignmentName, Context context) {
        return (Response)this.deleteWithResponseAsync(scope, roleAssignmentName, context).block();
    }

    @Override
    public Mono<Response<RoleAssignmentInner>> createWithResponseAsync(String scope, String roleAssignmentName, RoleAssignmentCreateParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleAssignmentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2018-01-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), scope, roleAssignmentName, "2018-01-01-preview", parameters, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<RoleAssignmentInner>> createWithResponseAsync(String scope, String roleAssignmentName, RoleAssignmentCreateParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleAssignmentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2018-01-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), scope, roleAssignmentName, "2018-01-01-preview", parameters, "application/json", context);
    }

    @Override
    public Mono<RoleAssignmentInner> createAsync(String scope, String roleAssignmentName, RoleAssignmentCreateParameters parameters) {
        return this.createWithResponseAsync(scope, roleAssignmentName, parameters).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((RoleAssignmentInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public RoleAssignmentInner create(String scope, String roleAssignmentName, RoleAssignmentCreateParameters parameters) {
        return (RoleAssignmentInner)this.createAsync(scope, roleAssignmentName, parameters).block();
    }

    @Override
    public Response<RoleAssignmentInner> createWithResponse(String scope, String roleAssignmentName, RoleAssignmentCreateParameters parameters, Context context) {
        return (Response)this.createWithResponseAsync(scope, roleAssignmentName, parameters, context).block();
    }

    @Override
    public Mono<Response<RoleAssignmentInner>> getWithResponseAsync(String scope, String roleAssignmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleAssignmentName is required and cannot be null."));
        }
        String apiVersion = "2018-01-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), scope, roleAssignmentName, "2018-01-01-preview", "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<RoleAssignmentInner>> getWithResponseAsync(String scope, String roleAssignmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleAssignmentName is required and cannot be null."));
        }
        String apiVersion = "2018-01-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), scope, roleAssignmentName, "2018-01-01-preview", "application/json", context);
    }

    @Override
    public Mono<RoleAssignmentInner> getAsync(String scope, String roleAssignmentName) {
        return this.getWithResponseAsync(scope, roleAssignmentName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((RoleAssignmentInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public RoleAssignmentInner get(String scope, String roleAssignmentName) {
        return (RoleAssignmentInner)this.getAsync(scope, roleAssignmentName).block();
    }

    @Override
    public Response<RoleAssignmentInner> getWithResponse(String scope, String roleAssignmentName, Context context) {
        return (Response)this.getWithResponseAsync(scope, roleAssignmentName, context).block();
    }

    @Override
    public Mono<Response<RoleAssignmentInner>> deleteByIdWithResponseAsync(String roleId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleId is required and cannot be null."));
        }
        String apiVersion = "2018-01-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteById(this.client.getEndpoint(), roleId, "2018-01-01-preview", "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<RoleAssignmentInner>> deleteByIdWithResponseAsync(String roleId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleId is required and cannot be null."));
        }
        String apiVersion = "2018-01-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteById(this.client.getEndpoint(), roleId, "2018-01-01-preview", "application/json", context);
    }

    @Override
    public Mono<RoleAssignmentInner> deleteByIdAsync(String roleId) {
        return this.deleteByIdWithResponseAsync(roleId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((RoleAssignmentInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public RoleAssignmentInner deleteById(String roleId) {
        return (RoleAssignmentInner)this.deleteByIdAsync(roleId).block();
    }

    @Override
    public Response<RoleAssignmentInner> deleteByIdWithResponse(String roleId, Context context) {
        return (Response)this.deleteByIdWithResponseAsync(roleId, context).block();
    }

    @Override
    public Mono<Response<RoleAssignmentInner>> createByIdWithResponseAsync(String roleId, RoleAssignmentCreateParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleId is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2018-01-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createById(this.client.getEndpoint(), roleId, "2018-01-01-preview", parameters, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<RoleAssignmentInner>> createByIdWithResponseAsync(String roleId, RoleAssignmentCreateParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleId is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2018-01-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createById(this.client.getEndpoint(), roleId, "2018-01-01-preview", parameters, "application/json", context);
    }

    @Override
    public Mono<RoleAssignmentInner> createByIdAsync(String roleId, RoleAssignmentCreateParameters parameters) {
        return this.createByIdWithResponseAsync(roleId, parameters).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((RoleAssignmentInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public RoleAssignmentInner createById(String roleId, RoleAssignmentCreateParameters parameters) {
        return (RoleAssignmentInner)this.createByIdAsync(roleId, parameters).block();
    }

    @Override
    public Response<RoleAssignmentInner> createByIdWithResponse(String roleId, RoleAssignmentCreateParameters parameters, Context context) {
        return (Response)this.createByIdWithResponseAsync(roleId, parameters, context).block();
    }

    @Override
    public Mono<Response<RoleAssignmentInner>> getByIdWithResponseAsync(String roleId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleId is required and cannot be null."));
        }
        String apiVersion = "2018-01-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getById(this.client.getEndpoint(), roleId, "2018-01-01-preview", "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<RoleAssignmentInner>> getByIdWithResponseAsync(String roleId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleId is required and cannot be null."));
        }
        String apiVersion = "2018-01-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getById(this.client.getEndpoint(), roleId, "2018-01-01-preview", "application/json", context);
    }

    @Override
    public Mono<RoleAssignmentInner> getByIdAsync(String roleId) {
        return this.getByIdWithResponseAsync(roleId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((RoleAssignmentInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public RoleAssignmentInner getById(String roleId) {
        return (RoleAssignmentInner)this.getByIdAsync(roleId).block();
    }

    @Override
    public Response<RoleAssignmentInner> getByIdWithResponse(String roleId, Context context) {
        return (Response)this.getByIdWithResponseAsync(roleId, context).block();
    }

    private Mono<PagedResponse<RoleAssignmentInner>> listSinglePageAsync(String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2018-01-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), filter, "2018-01-01-preview", this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).value(), ((RoleAssignmentListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<RoleAssignmentInner>> listSinglePageAsync(String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2018-01-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), filter, "2018-01-01-preview", this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).value(), ((RoleAssignmentListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<RoleAssignmentInner> listAsync(String filter) {
        return new PagedFlux(() -> this.listSinglePageAsync(filter), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<RoleAssignmentInner> listAsync() {
        String filter = null;
        return new PagedFlux(() -> this.listSinglePageAsync(filter), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<RoleAssignmentInner> listAsync(String filter, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(filter, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<RoleAssignmentInner> list() {
        String filter = null;
        return new PagedIterable(this.listAsync(filter));
    }

    @Override
    public PagedIterable<RoleAssignmentInner> list(String filter, Context context) {
        return new PagedIterable(this.listAsync(filter, context));
    }

    private Mono<PagedResponse<RoleAssignmentInner>> listForScopeSinglePageAsync(String scope, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        String apiVersion = "2018-01-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listForScope(this.client.getEndpoint(), scope, filter, "2018-01-01-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).value(), ((RoleAssignmentListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<RoleAssignmentInner>> listForScopeSinglePageAsync(String scope, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        String apiVersion = "2018-01-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listForScope(this.client.getEndpoint(), scope, filter, "2018-01-01-preview", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).value(), ((RoleAssignmentListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<RoleAssignmentInner> listForScopeAsync(String scope, String filter) {
        return new PagedFlux(() -> this.listForScopeSinglePageAsync(scope, filter), nextLink -> this.listForScopeNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<RoleAssignmentInner> listForScopeAsync(String scope) {
        String filter = null;
        return new PagedFlux(() -> this.listForScopeSinglePageAsync(scope, filter), nextLink -> this.listForScopeNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<RoleAssignmentInner> listForScopeAsync(String scope, String filter, Context context) {
        return new PagedFlux(() -> this.listForScopeSinglePageAsync(scope, filter, context), nextLink -> this.listForScopeNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<RoleAssignmentInner> listForScope(String scope) {
        String filter = null;
        return new PagedIterable(this.listForScopeAsync(scope, filter));
    }

    @Override
    public PagedIterable<RoleAssignmentInner> listForScope(String scope, String filter, Context context) {
        return new PagedIterable(this.listForScopeAsync(scope, filter, context));
    }

    private Mono<PagedResponse<RoleAssignmentInner>> listForResourceNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listForResourceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).value(), ((RoleAssignmentListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<RoleAssignmentInner>> listForResourceNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listForResourceNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).value(), ((RoleAssignmentListResult)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<RoleAssignmentInner>> listForResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listForResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).value(), ((RoleAssignmentListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<RoleAssignmentInner>> listForResourceGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listForResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).value(), ((RoleAssignmentListResult)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<RoleAssignmentInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).value(), ((RoleAssignmentListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<RoleAssignmentInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).value(), ((RoleAssignmentListResult)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<RoleAssignmentInner>> listForScopeNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listForScopeNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).value(), ((RoleAssignmentListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<RoleAssignmentInner>> listForScopeNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listForScopeNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).value(), ((RoleAssignmentListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AuthorizationManagem")
    private static interface RoleAssignmentsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/roleAssignments")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleAssignmentListResult>> listForResource(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="resourceProviderNamespace") String var3, @PathParam(value="parentResourcePath", encoded=true) String var4, @PathParam(value="resourceType", encoded=true) String var5, @PathParam(value="resourceName") String var6, @QueryParam(value="$filter") String var7, @QueryParam(value="api-version") String var8, @PathParam(value="subscriptionId") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/roleAssignments")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleAssignmentListResult>> listByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="$filter") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleAssignmentInner>> delete(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="roleAssignmentName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleAssignmentInner>> create(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="roleAssignmentName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") RoleAssignmentCreateParameters var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleAssignmentInner>> get(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="roleAssignmentName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/{roleId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleAssignmentInner>> deleteById(@HostParam(value="$host") String var1, @PathParam(value="roleId", encoded=true) String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/{roleId}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleAssignmentInner>> createById(@HostParam(value="$host") String var1, @PathParam(value="roleId", encoded=true) String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") RoleAssignmentCreateParameters var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{roleId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleAssignmentInner>> getById(@HostParam(value="$host") String var1, @PathParam(value="roleId", encoded=true) String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/roleAssignments")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleAssignmentListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="$filter") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{scope}/providers/Microsoft.Authorization/roleAssignments")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleAssignmentListResult>> listForScope(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @QueryParam(value="$filter") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleAssignmentListResult>> listForResourceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleAssignmentListResult>> listForResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleAssignmentListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleAssignmentListResult>> listForScopeNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

