/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.GroupLifecyclePoliciesGroupLifecyclePoliciesClient;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfGroupLifecyclePolicy;
import com.azure.resourcemanager.authorization.fluent.models.Get1ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.Get2ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.Get5ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.Get6ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.Get7ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphGroupLifecyclePolicyInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.azure.resourcemanager.authorization.implementation.MicrosoftGraphClientImpl;
import java.util.List;
import reactor.core.publisher.Mono;

public final class GroupLifecyclePoliciesGroupLifecyclePoliciesClientImpl
implements GroupLifecyclePoliciesGroupLifecyclePoliciesClient {
    private final ClientLogger logger = new ClientLogger(GroupLifecyclePoliciesGroupLifecyclePoliciesClientImpl.class);
    private final GroupLifecyclePoliciesGroupLifecyclePoliciesService service;
    private final MicrosoftGraphClientImpl client;

    GroupLifecyclePoliciesGroupLifecyclePoliciesClientImpl(MicrosoftGraphClientImpl client) {
        this.service = (GroupLifecyclePoliciesGroupLifecyclePoliciesService)RestProxy.create(GroupLifecyclePoliciesGroupLifecyclePoliciesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<MicrosoftGraphGroupLifecyclePolicyInner>> listGroupLifecyclePolicySinglePageAsync(Integer top, Integer skip, String search, String filter, Boolean count, List<Get5ItemsItem> orderby, List<Get6ItemsItem> select, List<Get7ItemsItem> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listGroupLifecyclePolicy(this.client.getEndpoint(), top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfGroupLifecyclePolicy)res.getValue()).value(), ((CollectionOfGroupLifecyclePolicy)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphGroupLifecyclePolicyInner>> listGroupLifecyclePolicySinglePageAsync(Integer top, Integer skip, String search, String filter, Boolean count, List<Get5ItemsItem> orderby, List<Get6ItemsItem> select, List<Get7ItemsItem> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listGroupLifecyclePolicy(this.client.getEndpoint(), top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfGroupLifecyclePolicy)res.getValue()).value(), ((CollectionOfGroupLifecyclePolicy)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<MicrosoftGraphGroupLifecyclePolicyInner> listGroupLifecyclePolicyAsync(Integer top, Integer skip, String search, String filter, Boolean count, List<Get5ItemsItem> orderby, List<Get6ItemsItem> select, List<Get7ItemsItem> expand) {
        return new PagedFlux(() -> this.listGroupLifecyclePolicySinglePageAsync(top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<MicrosoftGraphGroupLifecyclePolicyInner> listGroupLifecyclePolicyAsync() {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listGroupLifecyclePolicySinglePageAsync(top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    private PagedFlux<MicrosoftGraphGroupLifecyclePolicyInner> listGroupLifecyclePolicyAsync(Integer top, Integer skip, String search, String filter, Boolean count, List<Get5ItemsItem> orderby, List<Get6ItemsItem> select, List<Get7ItemsItem> expand, Context context) {
        return new PagedFlux(() -> this.listGroupLifecyclePolicySinglePageAsync(top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listMoreSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<MicrosoftGraphGroupLifecyclePolicyInner> listGroupLifecyclePolicy() {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<Get5ItemsItem> orderby = null;
        List<Get6ItemsItem> select = null;
        List<Get7ItemsItem> expand = null;
        return new PagedIterable(this.listGroupLifecyclePolicyAsync(top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    public PagedIterable<MicrosoftGraphGroupLifecyclePolicyInner> listGroupLifecyclePolicy(Integer top, Integer skip, String search, String filter, Boolean count, List<Get5ItemsItem> orderby, List<Get6ItemsItem> select, List<Get7ItemsItem> expand, Context context) {
        return new PagedIterable(this.listGroupLifecyclePolicyAsync(top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    public Mono<Response<MicrosoftGraphGroupLifecyclePolicyInner>> createGroupLifecyclePolicyWithResponseAsync(MicrosoftGraphGroupLifecyclePolicyInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createGroupLifecyclePolicy(this.client.getEndpoint(), body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphGroupLifecyclePolicyInner>> createGroupLifecyclePolicyWithResponseAsync(MicrosoftGraphGroupLifecyclePolicyInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createGroupLifecyclePolicy(this.client.getEndpoint(), body, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphGroupLifecyclePolicyInner> createGroupLifecyclePolicyAsync(MicrosoftGraphGroupLifecyclePolicyInner body) {
        return this.createGroupLifecyclePolicyWithResponseAsync(body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphGroupLifecyclePolicyInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphGroupLifecyclePolicyInner createGroupLifecyclePolicy(MicrosoftGraphGroupLifecyclePolicyInner body) {
        return (MicrosoftGraphGroupLifecyclePolicyInner)this.createGroupLifecyclePolicyAsync(body).block();
    }

    @Override
    public Response<MicrosoftGraphGroupLifecyclePolicyInner> createGroupLifecyclePolicyWithResponse(MicrosoftGraphGroupLifecyclePolicyInner body, Context context) {
        return (Response)this.createGroupLifecyclePolicyWithResponseAsync(body, context).block();
    }

    @Override
    public Mono<Response<MicrosoftGraphGroupLifecyclePolicyInner>> getGroupLifecyclePolicyWithResponseAsync(String groupLifecyclePolicyId, List<Get1ItemsItem> select, List<Get2ItemsItem> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupLifecyclePolicyId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupLifecyclePolicyId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getGroupLifecyclePolicy(this.client.getEndpoint(), groupLifecyclePolicyId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphGroupLifecyclePolicyInner>> getGroupLifecyclePolicyWithResponseAsync(String groupLifecyclePolicyId, List<Get1ItemsItem> select, List<Get2ItemsItem> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupLifecyclePolicyId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupLifecyclePolicyId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getGroupLifecyclePolicy(this.client.getEndpoint(), groupLifecyclePolicyId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphGroupLifecyclePolicyInner> getGroupLifecyclePolicyAsync(String groupLifecyclePolicyId, List<Get1ItemsItem> select, List<Get2ItemsItem> expand) {
        return this.getGroupLifecyclePolicyWithResponseAsync(groupLifecyclePolicyId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphGroupLifecyclePolicyInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<MicrosoftGraphGroupLifecyclePolicyInner> getGroupLifecyclePolicyAsync(String groupLifecyclePolicyId) {
        List<Get1ItemsItem> select = null;
        List<Get2ItemsItem> expand = null;
        return this.getGroupLifecyclePolicyWithResponseAsync(groupLifecyclePolicyId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphGroupLifecyclePolicyInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphGroupLifecyclePolicyInner getGroupLifecyclePolicy(String groupLifecyclePolicyId) {
        List<Get1ItemsItem> select = null;
        List<Get2ItemsItem> expand = null;
        return (MicrosoftGraphGroupLifecyclePolicyInner)this.getGroupLifecyclePolicyAsync(groupLifecyclePolicyId, select, expand).block();
    }

    @Override
    public Response<MicrosoftGraphGroupLifecyclePolicyInner> getGroupLifecyclePolicyWithResponse(String groupLifecyclePolicyId, List<Get1ItemsItem> select, List<Get2ItemsItem> expand, Context context) {
        return (Response)this.getGroupLifecyclePolicyWithResponseAsync(groupLifecyclePolicyId, select, expand, context).block();
    }

    @Override
    public Mono<Response<Void>> updateGroupLifecyclePolicyWithResponseAsync(String groupLifecyclePolicyId, MicrosoftGraphGroupLifecyclePolicyInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupLifecyclePolicyId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupLifecyclePolicyId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateGroupLifecyclePolicy(this.client.getEndpoint(), groupLifecyclePolicyId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> updateGroupLifecyclePolicyWithResponseAsync(String groupLifecyclePolicyId, MicrosoftGraphGroupLifecyclePolicyInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupLifecyclePolicyId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupLifecyclePolicyId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateGroupLifecyclePolicy(this.client.getEndpoint(), groupLifecyclePolicyId, body, "application/json", context);
    }

    @Override
    public Mono<Void> updateGroupLifecyclePolicyAsync(String groupLifecyclePolicyId, MicrosoftGraphGroupLifecyclePolicyInner body) {
        return this.updateGroupLifecyclePolicyWithResponseAsync(groupLifecyclePolicyId, body).flatMap(res -> Mono.empty());
    }

    @Override
    public void updateGroupLifecyclePolicy(String groupLifecyclePolicyId, MicrosoftGraphGroupLifecyclePolicyInner body) {
        this.updateGroupLifecyclePolicyAsync(groupLifecyclePolicyId, body).block();
    }

    @Override
    public Response<Void> updateGroupLifecyclePolicyWithResponse(String groupLifecyclePolicyId, MicrosoftGraphGroupLifecyclePolicyInner body, Context context) {
        return (Response)this.updateGroupLifecyclePolicyWithResponseAsync(groupLifecyclePolicyId, body, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteGroupLifecyclePolicyWithResponseAsync(String groupLifecyclePolicyId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupLifecyclePolicyId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupLifecyclePolicyId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteGroupLifecyclePolicy(this.client.getEndpoint(), groupLifecyclePolicyId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteGroupLifecyclePolicyWithResponseAsync(String groupLifecyclePolicyId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupLifecyclePolicyId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupLifecyclePolicyId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteGroupLifecyclePolicy(this.client.getEndpoint(), groupLifecyclePolicyId, ifMatch, "application/json", context);
    }

    @Override
    public Mono<Void> deleteGroupLifecyclePolicyAsync(String groupLifecyclePolicyId, String ifMatch) {
        return this.deleteGroupLifecyclePolicyWithResponseAsync(groupLifecyclePolicyId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public Mono<Void> deleteGroupLifecyclePolicyAsync(String groupLifecyclePolicyId) {
        String ifMatch = null;
        return this.deleteGroupLifecyclePolicyWithResponseAsync(groupLifecyclePolicyId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public void deleteGroupLifecyclePolicy(String groupLifecyclePolicyId) {
        String ifMatch = null;
        this.deleteGroupLifecyclePolicyAsync(groupLifecyclePolicyId, ifMatch).block();
    }

    @Override
    public Response<Void> deleteGroupLifecyclePolicyWithResponse(String groupLifecyclePolicyId, String ifMatch, Context context) {
        return (Response)this.deleteGroupLifecyclePolicyWithResponseAsync(groupLifecyclePolicyId, ifMatch, context).block();
    }

    private Mono<PagedResponse<MicrosoftGraphGroupLifecyclePolicyInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listMore(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfGroupLifecyclePolicy)res.getValue()).value(), ((CollectionOfGroupLifecyclePolicy)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphGroupLifecyclePolicyInner>> listMoreSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listMore(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfGroupLifecyclePolicy)res.getValue()).value(), ((CollectionOfGroupLifecyclePolicy)res.getValue()).odataNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MicrosoftGraphClient")
    private static interface GroupLifecyclePoliciesGroupLifecyclePoliciesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/groupLifecyclePolicies")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfGroupLifecyclePolicy>> listGroupLifecyclePolicy(@HostParam(value="$host") String var1, @QueryParam(value="$top") Integer var2, @QueryParam(value="$skip") Integer var3, @QueryParam(value="$search") String var4, @QueryParam(value="$filter") String var5, @QueryParam(value="$count") Boolean var6, @QueryParam(value="$orderby") String var7, @QueryParam(value="$select") String var8, @QueryParam(value="$expand") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/groupLifecyclePolicies")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphGroupLifecyclePolicyInner>> createGroupLifecyclePolicy(@HostParam(value="$host") String var1, @BodyParam(value="application/json") MicrosoftGraphGroupLifecyclePolicyInner var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/groupLifecyclePolicies/{groupLifecyclePolicy-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphGroupLifecyclePolicyInner>> getGroupLifecyclePolicy(@HostParam(value="$host") String var1, @PathParam(value="groupLifecyclePolicy-id") String var2, @QueryParam(value="$select") String var3, @QueryParam(value="$expand") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/groupLifecyclePolicies/{groupLifecyclePolicy-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateGroupLifecyclePolicy(@HostParam(value="$host") String var1, @PathParam(value="groupLifecyclePolicy-id") String var2, @BodyParam(value="application/json") MicrosoftGraphGroupLifecyclePolicyInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/groupLifecyclePolicies/{groupLifecyclePolicy-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteGroupLifecyclePolicy(@HostParam(value="$host") String var1, @PathParam(value="groupLifecyclePolicy-id") String var2, @HeaderParam(value="If-Match") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfGroupLifecyclePolicy>> listMore(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

