/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.DirectoryAdministrativeUnitsClient;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject6;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfExtension0;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObject6;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfScopedRoleMembership;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryAdministrativeUnitsOrderby;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryAdministrativeUnitsSelect;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphAdministrativeUnitInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryObjectInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphExtensionInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphScopedRoleMembershipInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.azure.resourcemanager.authorization.implementation.MicrosoftGraphClientImpl;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

public final class DirectoryAdministrativeUnitsClientImpl
implements DirectoryAdministrativeUnitsClient {
    private final ClientLogger logger = new ClientLogger(DirectoryAdministrativeUnitsClientImpl.class);
    private final DirectoryAdministrativeUnitsService service;
    private final MicrosoftGraphClientImpl client;

    DirectoryAdministrativeUnitsClientImpl(MicrosoftGraphClientImpl client) {
        this.service = (DirectoryAdministrativeUnitsService)RestProxy.create(DirectoryAdministrativeUnitsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listExtensionsSinglePageAsync(String administrativeUnitId, Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryAdministrativeUnitsOrderby> orderby, List<String> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listExtensions(this.client.getEndpoint(), administrativeUnitId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfExtension0)res.getValue()).value(), ((CollectionOfExtension0)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listExtensionsSinglePageAsync(String administrativeUnitId, Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryAdministrativeUnitsOrderby> orderby, List<String> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listExtensions(this.client.getEndpoint(), administrativeUnitId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfExtension0)res.getValue()).value(), ((CollectionOfExtension0)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<MicrosoftGraphExtensionInner> listExtensionsAsync(String administrativeUnitId, Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryAdministrativeUnitsOrderby> orderby, List<String> select, List<String> expand) {
        return new PagedFlux(() -> this.listExtensionsSinglePageAsync(administrativeUnitId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<MicrosoftGraphExtensionInner> listExtensionsAsync(String administrativeUnitId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listExtensionsSinglePageAsync(administrativeUnitId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    private PagedFlux<MicrosoftGraphExtensionInner> listExtensionsAsync(String administrativeUnitId, Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryAdministrativeUnitsOrderby> orderby, List<String> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listExtensionsSinglePageAsync(administrativeUnitId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listMoreSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<MicrosoftGraphExtensionInner> listExtensions(String administrativeUnitId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<DirectoryAdministrativeUnitsOrderby> orderby = null;
        List<String> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listExtensionsAsync(administrativeUnitId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    public PagedIterable<MicrosoftGraphExtensionInner> listExtensions(String administrativeUnitId, Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryAdministrativeUnitsOrderby> orderby, List<String> select, List<String> expand, Context context) {
        return new PagedIterable(this.listExtensionsAsync(administrativeUnitId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    public Mono<Response<MicrosoftGraphExtensionInner>> createExtensionsWithResponseAsync(String administrativeUnitId, MicrosoftGraphExtensionInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createExtensions(this.client.getEndpoint(), administrativeUnitId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphExtensionInner>> createExtensionsWithResponseAsync(String administrativeUnitId, MicrosoftGraphExtensionInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createExtensions(this.client.getEndpoint(), administrativeUnitId, body, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphExtensionInner> createExtensionsAsync(String administrativeUnitId, MicrosoftGraphExtensionInner body) {
        return this.createExtensionsWithResponseAsync(administrativeUnitId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphExtensionInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphExtensionInner createExtensions(String administrativeUnitId, MicrosoftGraphExtensionInner body) {
        return (MicrosoftGraphExtensionInner)this.createExtensionsAsync(administrativeUnitId, body).block();
    }

    @Override
    public Response<MicrosoftGraphExtensionInner> createExtensionsWithResponse(String administrativeUnitId, MicrosoftGraphExtensionInner body, Context context) {
        return (Response)this.createExtensionsWithResponseAsync(administrativeUnitId, body, context).block();
    }

    @Override
    public Mono<Response<MicrosoftGraphExtensionInner>> getExtensionsWithResponseAsync(String administrativeUnitId, String extensionId, List<String> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getExtensions(this.client.getEndpoint(), administrativeUnitId, extensionId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphExtensionInner>> getExtensionsWithResponseAsync(String administrativeUnitId, String extensionId, List<String> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getExtensions(this.client.getEndpoint(), administrativeUnitId, extensionId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphExtensionInner> getExtensionsAsync(String administrativeUnitId, String extensionId, List<String> select, List<String> expand) {
        return this.getExtensionsWithResponseAsync(administrativeUnitId, extensionId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphExtensionInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<MicrosoftGraphExtensionInner> getExtensionsAsync(String administrativeUnitId, String extensionId) {
        List<String> select = null;
        List<String> expand = null;
        return this.getExtensionsWithResponseAsync(administrativeUnitId, extensionId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphExtensionInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphExtensionInner getExtensions(String administrativeUnitId, String extensionId) {
        List<String> select = null;
        List<String> expand = null;
        return (MicrosoftGraphExtensionInner)this.getExtensionsAsync(administrativeUnitId, extensionId, select, expand).block();
    }

    @Override
    public Response<MicrosoftGraphExtensionInner> getExtensionsWithResponse(String administrativeUnitId, String extensionId, List<String> select, List<String> expand, Context context) {
        return (Response)this.getExtensionsWithResponseAsync(administrativeUnitId, extensionId, select, expand, context).block();
    }

    @Override
    public Mono<Response<Void>> updateExtensionsWithResponseAsync(String administrativeUnitId, String extensionId, MicrosoftGraphExtensionInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateExtensions(this.client.getEndpoint(), administrativeUnitId, extensionId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> updateExtensionsWithResponseAsync(String administrativeUnitId, String extensionId, MicrosoftGraphExtensionInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateExtensions(this.client.getEndpoint(), administrativeUnitId, extensionId, body, "application/json", context);
    }

    @Override
    public Mono<Void> updateExtensionsAsync(String administrativeUnitId, String extensionId, MicrosoftGraphExtensionInner body) {
        return this.updateExtensionsWithResponseAsync(administrativeUnitId, extensionId, body).flatMap(res -> Mono.empty());
    }

    @Override
    public void updateExtensions(String administrativeUnitId, String extensionId, MicrosoftGraphExtensionInner body) {
        this.updateExtensionsAsync(administrativeUnitId, extensionId, body).block();
    }

    @Override
    public Response<Void> updateExtensionsWithResponse(String administrativeUnitId, String extensionId, MicrosoftGraphExtensionInner body, Context context) {
        return (Response)this.updateExtensionsWithResponseAsync(administrativeUnitId, extensionId, body, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteExtensionsWithResponseAsync(String administrativeUnitId, String extensionId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteExtensions(this.client.getEndpoint(), administrativeUnitId, extensionId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteExtensionsWithResponseAsync(String administrativeUnitId, String extensionId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteExtensions(this.client.getEndpoint(), administrativeUnitId, extensionId, ifMatch, "application/json", context);
    }

    @Override
    public Mono<Void> deleteExtensionsAsync(String administrativeUnitId, String extensionId, String ifMatch) {
        return this.deleteExtensionsWithResponseAsync(administrativeUnitId, extensionId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public Mono<Void> deleteExtensionsAsync(String administrativeUnitId, String extensionId) {
        String ifMatch = null;
        return this.deleteExtensionsWithResponseAsync(administrativeUnitId, extensionId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public void deleteExtensions(String administrativeUnitId, String extensionId) {
        String ifMatch = null;
        this.deleteExtensionsAsync(administrativeUnitId, extensionId, ifMatch).block();
    }

    @Override
    public Response<Void> deleteExtensionsWithResponse(String administrativeUnitId, String extensionId, String ifMatch, Context context) {
        return (Response)this.deleteExtensionsWithResponseAsync(administrativeUnitId, extensionId, ifMatch, context).block();
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMembersSinglePageAsync(String administrativeUnitId, Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryAdministrativeUnitsOrderby> orderby, List<DirectoryAdministrativeUnitsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listMembers(this.client.getEndpoint(), administrativeUnitId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject6)res.getValue()).value(), ((CollectionOfDirectoryObject6)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMembersSinglePageAsync(String administrativeUnitId, Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryAdministrativeUnitsOrderby> orderby, List<DirectoryAdministrativeUnitsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listMembers(this.client.getEndpoint(), administrativeUnitId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject6)res.getValue()).value(), ((CollectionOfDirectoryObject6)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listMembersAsync(String administrativeUnitId, Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryAdministrativeUnitsOrderby> orderby, List<DirectoryAdministrativeUnitsSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listMembersSinglePageAsync(administrativeUnitId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMembersNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listMembersAsync(String administrativeUnitId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listMembersSinglePageAsync(administrativeUnitId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMembersNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listMembersAsync(String administrativeUnitId, Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryAdministrativeUnitsOrderby> orderby, List<DirectoryAdministrativeUnitsSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listMembersSinglePageAsync(administrativeUnitId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listMembersNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listMembers(String administrativeUnitId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<DirectoryAdministrativeUnitsOrderby> orderby = null;
        List<DirectoryAdministrativeUnitsSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listMembersAsync(administrativeUnitId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listMembers(String administrativeUnitId, Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryAdministrativeUnitsOrderby> orderby, List<DirectoryAdministrativeUnitsSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listMembersAsync(administrativeUnitId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    private Mono<PagedResponse<String>> listRefMembersSinglePageAsync(String administrativeUnitId, Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryAdministrativeUnitsOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listRefMembers(this.client.getEndpoint(), administrativeUnitId, top, skip, search, filter, count, orderbyConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject6)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject6)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<String>> listRefMembersSinglePageAsync(String administrativeUnitId, Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryAdministrativeUnitsOrderby> orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listRefMembers(this.client.getEndpoint(), administrativeUnitId, top, skip, search, filter, count, orderbyConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject6)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject6)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<String> listRefMembersAsync(String administrativeUnitId, Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryAdministrativeUnitsOrderby> orderby) {
        return new PagedFlux(() -> this.listRefMembersSinglePageAsync(administrativeUnitId, top, skip, search, filter, count, orderby), nextLink -> this.listRefMembersNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<String> listRefMembersAsync(String administrativeUnitId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        return new PagedFlux(() -> this.listRefMembersSinglePageAsync(administrativeUnitId, top, skip, search, filter, count, orderby), nextLink -> this.listRefMembersNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<String> listRefMembersAsync(String administrativeUnitId, Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryAdministrativeUnitsOrderby> orderby, Context context) {
        return new PagedFlux(() -> this.listRefMembersSinglePageAsync(administrativeUnitId, top, skip, search, filter, count, orderby, context), nextLink -> this.listRefMembersNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<String> listRefMembers(String administrativeUnitId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<DirectoryAdministrativeUnitsOrderby> orderby = null;
        return new PagedIterable(this.listRefMembersAsync(administrativeUnitId, top, skip, search, filter, count, orderby));
    }

    @Override
    public PagedIterable<String> listRefMembers(String administrativeUnitId, Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryAdministrativeUnitsOrderby> orderby, Context context) {
        return new PagedIterable(this.listRefMembersAsync(administrativeUnitId, top, skip, search, filter, count, orderby, context));
    }

    @Override
    public Mono<Response<Map<String, Object>>> createRefMembersWithResponseAsync(String administrativeUnitId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRefMembers(this.client.getEndpoint(), administrativeUnitId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Map<String, Object>>> createRefMembersWithResponseAsync(String administrativeUnitId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createRefMembers(this.client.getEndpoint(), administrativeUnitId, body, "application/json", context);
    }

    @Override
    public Mono<Map<String, Object>> createRefMembersAsync(String administrativeUnitId, Map<String, Object> body) {
        return this.createRefMembersWithResponseAsync(administrativeUnitId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Map)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Map<String, Object> createRefMembers(String administrativeUnitId, Map<String, Object> body) {
        return (Map)this.createRefMembersAsync(administrativeUnitId, body).block();
    }

    @Override
    public Response<Map<String, Object>> createRefMembersWithResponse(String administrativeUnitId, Map<String, Object> body, Context context) {
        return (Response)this.createRefMembersWithResponseAsync(administrativeUnitId, body, context).block();
    }

    private Mono<PagedResponse<MicrosoftGraphScopedRoleMembershipInner>> listScopedRoleMembersSinglePageAsync(String administrativeUnitId, Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryAdministrativeUnitsOrderby> orderby, List<DirectoryAdministrativeUnitsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listScopedRoleMembers(this.client.getEndpoint(), administrativeUnitId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfScopedRoleMembership)res.getValue()).value(), ((CollectionOfScopedRoleMembership)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphScopedRoleMembershipInner>> listScopedRoleMembersSinglePageAsync(String administrativeUnitId, Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryAdministrativeUnitsOrderby> orderby, List<DirectoryAdministrativeUnitsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listScopedRoleMembers(this.client.getEndpoint(), administrativeUnitId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfScopedRoleMembership)res.getValue()).value(), ((CollectionOfScopedRoleMembership)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<MicrosoftGraphScopedRoleMembershipInner> listScopedRoleMembersAsync(String administrativeUnitId, Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryAdministrativeUnitsOrderby> orderby, List<DirectoryAdministrativeUnitsSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listScopedRoleMembersSinglePageAsync(administrativeUnitId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listScopedRoleMembersNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<MicrosoftGraphScopedRoleMembershipInner> listScopedRoleMembersAsync(String administrativeUnitId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listScopedRoleMembersSinglePageAsync(administrativeUnitId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listScopedRoleMembersNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<MicrosoftGraphScopedRoleMembershipInner> listScopedRoleMembersAsync(String administrativeUnitId, Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryAdministrativeUnitsOrderby> orderby, List<DirectoryAdministrativeUnitsSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listScopedRoleMembersSinglePageAsync(administrativeUnitId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listScopedRoleMembersNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<MicrosoftGraphScopedRoleMembershipInner> listScopedRoleMembers(String administrativeUnitId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<DirectoryAdministrativeUnitsOrderby> orderby = null;
        List<DirectoryAdministrativeUnitsSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listScopedRoleMembersAsync(administrativeUnitId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    public PagedIterable<MicrosoftGraphScopedRoleMembershipInner> listScopedRoleMembers(String administrativeUnitId, Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryAdministrativeUnitsOrderby> orderby, List<DirectoryAdministrativeUnitsSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listScopedRoleMembersAsync(administrativeUnitId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    public Mono<Response<MicrosoftGraphScopedRoleMembershipInner>> createScopedRoleMembersWithResponseAsync(String administrativeUnitId, MicrosoftGraphScopedRoleMembershipInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createScopedRoleMembers(this.client.getEndpoint(), administrativeUnitId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphScopedRoleMembershipInner>> createScopedRoleMembersWithResponseAsync(String administrativeUnitId, MicrosoftGraphScopedRoleMembershipInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createScopedRoleMembers(this.client.getEndpoint(), administrativeUnitId, body, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphScopedRoleMembershipInner> createScopedRoleMembersAsync(String administrativeUnitId, MicrosoftGraphScopedRoleMembershipInner body) {
        return this.createScopedRoleMembersWithResponseAsync(administrativeUnitId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphScopedRoleMembershipInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphScopedRoleMembershipInner createScopedRoleMembers(String administrativeUnitId, MicrosoftGraphScopedRoleMembershipInner body) {
        return (MicrosoftGraphScopedRoleMembershipInner)this.createScopedRoleMembersAsync(administrativeUnitId, body).block();
    }

    @Override
    public Response<MicrosoftGraphScopedRoleMembershipInner> createScopedRoleMembersWithResponse(String administrativeUnitId, MicrosoftGraphScopedRoleMembershipInner body, Context context) {
        return (Response)this.createScopedRoleMembersWithResponseAsync(administrativeUnitId, body, context).block();
    }

    @Override
    public Mono<Response<MicrosoftGraphScopedRoleMembershipInner>> getScopedRoleMembersWithResponseAsync(String administrativeUnitId, String scopedRoleMembershipId, List<DirectoryAdministrativeUnitsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        if (scopedRoleMembershipId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopedRoleMembershipId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getScopedRoleMembers(this.client.getEndpoint(), administrativeUnitId, scopedRoleMembershipId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphScopedRoleMembershipInner>> getScopedRoleMembersWithResponseAsync(String administrativeUnitId, String scopedRoleMembershipId, List<DirectoryAdministrativeUnitsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        if (scopedRoleMembershipId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopedRoleMembershipId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getScopedRoleMembers(this.client.getEndpoint(), administrativeUnitId, scopedRoleMembershipId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphScopedRoleMembershipInner> getScopedRoleMembersAsync(String administrativeUnitId, String scopedRoleMembershipId, List<DirectoryAdministrativeUnitsSelect> select, List<String> expand) {
        return this.getScopedRoleMembersWithResponseAsync(administrativeUnitId, scopedRoleMembershipId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphScopedRoleMembershipInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<MicrosoftGraphScopedRoleMembershipInner> getScopedRoleMembersAsync(String administrativeUnitId, String scopedRoleMembershipId) {
        List<DirectoryAdministrativeUnitsSelect> select = null;
        List<String> expand = null;
        return this.getScopedRoleMembersWithResponseAsync(administrativeUnitId, scopedRoleMembershipId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphScopedRoleMembershipInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphScopedRoleMembershipInner getScopedRoleMembers(String administrativeUnitId, String scopedRoleMembershipId) {
        List<DirectoryAdministrativeUnitsSelect> select = null;
        List<String> expand = null;
        return (MicrosoftGraphScopedRoleMembershipInner)this.getScopedRoleMembersAsync(administrativeUnitId, scopedRoleMembershipId, select, expand).block();
    }

    @Override
    public Response<MicrosoftGraphScopedRoleMembershipInner> getScopedRoleMembersWithResponse(String administrativeUnitId, String scopedRoleMembershipId, List<DirectoryAdministrativeUnitsSelect> select, List<String> expand, Context context) {
        return (Response)this.getScopedRoleMembersWithResponseAsync(administrativeUnitId, scopedRoleMembershipId, select, expand, context).block();
    }

    @Override
    public Mono<Response<Void>> updateScopedRoleMembersWithResponseAsync(String administrativeUnitId, String scopedRoleMembershipId, MicrosoftGraphScopedRoleMembershipInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        if (scopedRoleMembershipId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopedRoleMembershipId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateScopedRoleMembers(this.client.getEndpoint(), administrativeUnitId, scopedRoleMembershipId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> updateScopedRoleMembersWithResponseAsync(String administrativeUnitId, String scopedRoleMembershipId, MicrosoftGraphScopedRoleMembershipInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        if (scopedRoleMembershipId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopedRoleMembershipId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateScopedRoleMembers(this.client.getEndpoint(), administrativeUnitId, scopedRoleMembershipId, body, "application/json", context);
    }

    @Override
    public Mono<Void> updateScopedRoleMembersAsync(String administrativeUnitId, String scopedRoleMembershipId, MicrosoftGraphScopedRoleMembershipInner body) {
        return this.updateScopedRoleMembersWithResponseAsync(administrativeUnitId, scopedRoleMembershipId, body).flatMap(res -> Mono.empty());
    }

    @Override
    public void updateScopedRoleMembers(String administrativeUnitId, String scopedRoleMembershipId, MicrosoftGraphScopedRoleMembershipInner body) {
        this.updateScopedRoleMembersAsync(administrativeUnitId, scopedRoleMembershipId, body).block();
    }

    @Override
    public Response<Void> updateScopedRoleMembersWithResponse(String administrativeUnitId, String scopedRoleMembershipId, MicrosoftGraphScopedRoleMembershipInner body, Context context) {
        return (Response)this.updateScopedRoleMembersWithResponseAsync(administrativeUnitId, scopedRoleMembershipId, body, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteScopedRoleMembersWithResponseAsync(String administrativeUnitId, String scopedRoleMembershipId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        if (scopedRoleMembershipId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopedRoleMembershipId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteScopedRoleMembers(this.client.getEndpoint(), administrativeUnitId, scopedRoleMembershipId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteScopedRoleMembersWithResponseAsync(String administrativeUnitId, String scopedRoleMembershipId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        if (scopedRoleMembershipId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopedRoleMembershipId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteScopedRoleMembers(this.client.getEndpoint(), administrativeUnitId, scopedRoleMembershipId, ifMatch, "application/json", context);
    }

    @Override
    public Mono<Void> deleteScopedRoleMembersAsync(String administrativeUnitId, String scopedRoleMembershipId, String ifMatch) {
        return this.deleteScopedRoleMembersWithResponseAsync(administrativeUnitId, scopedRoleMembershipId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public Mono<Void> deleteScopedRoleMembersAsync(String administrativeUnitId, String scopedRoleMembershipId) {
        String ifMatch = null;
        return this.deleteScopedRoleMembersWithResponseAsync(administrativeUnitId, scopedRoleMembershipId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public void deleteScopedRoleMembers(String administrativeUnitId, String scopedRoleMembershipId) {
        String ifMatch = null;
        this.deleteScopedRoleMembersAsync(administrativeUnitId, scopedRoleMembershipId, ifMatch).block();
    }

    @Override
    public Response<Void> deleteScopedRoleMembersWithResponse(String administrativeUnitId, String scopedRoleMembershipId, String ifMatch, Context context) {
        return (Response)this.deleteScopedRoleMembersWithResponseAsync(administrativeUnitId, scopedRoleMembershipId, ifMatch, context).block();
    }

    @Override
    public Mono<Response<List<MicrosoftGraphAdministrativeUnitInner>>> deltaWithResponseAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delta(this.client.getEndpoint(), "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<List<MicrosoftGraphAdministrativeUnitInner>>> deltaWithResponseAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delta(this.client.getEndpoint(), "application/json", context);
    }

    @Override
    public Mono<List<MicrosoftGraphAdministrativeUnitInner>> deltaAsync() {
        return this.deltaWithResponseAsync().flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public List<MicrosoftGraphAdministrativeUnitInner> delta() {
        return (List)this.deltaAsync().block();
    }

    @Override
    public Response<List<MicrosoftGraphAdministrativeUnitInner>> deltaWithResponse(Context context) {
        return (Response)this.deltaWithResponseAsync(context).block();
    }

    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listMore(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfExtension0)res.getValue()).value(), ((CollectionOfExtension0)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listMoreSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listMore(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfExtension0)res.getValue()).value(), ((CollectionOfExtension0)res.getValue()).odataNextLink(), null));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMembersNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listMembersNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject6)res.getValue()).value(), ((CollectionOfDirectoryObject6)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMembersNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listMembersNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject6)res.getValue()).value(), ((CollectionOfDirectoryObject6)res.getValue()).odataNextLink(), null));
    }

    private Mono<PagedResponse<String>> listRefMembersNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRefMembersNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject6)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject6)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<String>> listRefMembersNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRefMembersNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject6)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject6)res.getValue()).odataNextLink(), null));
    }

    private Mono<PagedResponse<MicrosoftGraphScopedRoleMembershipInner>> listScopedRoleMembersNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listScopedRoleMembersNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfScopedRoleMembership)res.getValue()).value(), ((CollectionOfScopedRoleMembership)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphScopedRoleMembershipInner>> listScopedRoleMembersNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listScopedRoleMembersNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfScopedRoleMembership)res.getValue()).value(), ((CollectionOfScopedRoleMembership)res.getValue()).odataNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MicrosoftGraphClient")
    private static interface DirectoryAdministrativeUnitsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/directory/administrativeUnits/{administrativeUnit-id}/extensions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfExtension0>> listExtensions(@HostParam(value="$host") String var1, @PathParam(value="administrativeUnit-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/directory/administrativeUnits/{administrativeUnit-id}/extensions")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphExtensionInner>> createExtensions(@HostParam(value="$host") String var1, @PathParam(value="administrativeUnit-id") String var2, @BodyParam(value="application/json") MicrosoftGraphExtensionInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/directory/administrativeUnits/{administrativeUnit-id}/extensions/{extension-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphExtensionInner>> getExtensions(@HostParam(value="$host") String var1, @PathParam(value="administrativeUnit-id") String var2, @PathParam(value="extension-id") String var3, @QueryParam(value="$select") String var4, @QueryParam(value="$expand") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/directory/administrativeUnits/{administrativeUnit-id}/extensions/{extension-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateExtensions(@HostParam(value="$host") String var1, @PathParam(value="administrativeUnit-id") String var2, @PathParam(value="extension-id") String var3, @BodyParam(value="application/json") MicrosoftGraphExtensionInner var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/directory/administrativeUnits/{administrativeUnit-id}/extensions/{extension-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteExtensions(@HostParam(value="$host") String var1, @PathParam(value="administrativeUnit-id") String var2, @PathParam(value="extension-id") String var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/directory/administrativeUnits/{administrativeUnit-id}/members")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject6>> listMembers(@HostParam(value="$host") String var1, @PathParam(value="administrativeUnit-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/directory/administrativeUnits/{administrativeUnit-id}/members/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject6>> listRefMembers(@HostParam(value="$host") String var1, @PathParam(value="administrativeUnit-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/directory/administrativeUnits/{administrativeUnit-id}/members/$ref")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Map<String, Object>>> createRefMembers(@HostParam(value="$host") String var1, @PathParam(value="administrativeUnit-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/directory/administrativeUnits/{administrativeUnit-id}/scopedRoleMembers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfScopedRoleMembership>> listScopedRoleMembers(@HostParam(value="$host") String var1, @PathParam(value="administrativeUnit-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/directory/administrativeUnits/{administrativeUnit-id}/scopedRoleMembers")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphScopedRoleMembershipInner>> createScopedRoleMembers(@HostParam(value="$host") String var1, @PathParam(value="administrativeUnit-id") String var2, @BodyParam(value="application/json") MicrosoftGraphScopedRoleMembershipInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/directory/administrativeUnits/{administrativeUnit-id}/scopedRoleMembers/{scopedRoleMembership-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphScopedRoleMembershipInner>> getScopedRoleMembers(@HostParam(value="$host") String var1, @PathParam(value="administrativeUnit-id") String var2, @PathParam(value="scopedRoleMembership-id") String var3, @QueryParam(value="$select") String var4, @QueryParam(value="$expand") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/directory/administrativeUnits/{administrativeUnit-id}/scopedRoleMembers/{scopedRoleMembership-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateScopedRoleMembers(@HostParam(value="$host") String var1, @PathParam(value="administrativeUnit-id") String var2, @PathParam(value="scopedRoleMembership-id") String var3, @BodyParam(value="application/json") MicrosoftGraphScopedRoleMembershipInner var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/directory/administrativeUnits/{administrativeUnit-id}/scopedRoleMembers/{scopedRoleMembership-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteScopedRoleMembers(@HostParam(value="$host") String var1, @PathParam(value="administrativeUnit-id") String var2, @PathParam(value="scopedRoleMembership-id") String var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/directory/administrativeUnits/microsoft.graph.delta()")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<MicrosoftGraphAdministrativeUnitInner>>> delta(@HostParam(value="$host") String var1, @HeaderParam(value="Accept") String var2, Context var3);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfExtension0>> listMore(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject6>> listMembersNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject6>> listRefMembersNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfScopedRoleMembership>> listScopedRoleMembersNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

