/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.ContractsContractsClient;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfContract;
import com.azure.resourcemanager.authorization.fluent.models.ContractsContractSelect;
import com.azure.resourcemanager.authorization.fluent.models.Get5ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphContractInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.azure.resourcemanager.authorization.implementation.MicrosoftGraphClientImpl;
import java.util.List;
import reactor.core.publisher.Mono;

public final class ContractsContractsClientImpl
implements ContractsContractsClient {
    private final ClientLogger logger = new ClientLogger(ContractsContractsClientImpl.class);
    private final ContractsContractsService service;
    private final MicrosoftGraphClientImpl client;

    ContractsContractsClientImpl(MicrosoftGraphClientImpl client) {
        this.service = (ContractsContractsService)RestProxy.create(ContractsContractsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<MicrosoftGraphContractInner>> listContractSinglePageAsync(Integer top, Integer skip, String search, String filter, Boolean count, List<Get5ItemsItem> orderby, List<ContractsContractSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listContract(this.client.getEndpoint(), top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfContract)res.getValue()).value(), ((CollectionOfContract)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphContractInner>> listContractSinglePageAsync(Integer top, Integer skip, String search, String filter, Boolean count, List<Get5ItemsItem> orderby, List<ContractsContractSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listContract(this.client.getEndpoint(), top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfContract)res.getValue()).value(), ((CollectionOfContract)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<MicrosoftGraphContractInner> listContractAsync(Integer top, Integer skip, String search, String filter, Boolean count, List<Get5ItemsItem> orderby, List<ContractsContractSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listContractSinglePageAsync(top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<MicrosoftGraphContractInner> listContractAsync() {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listContractSinglePageAsync(top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    private PagedFlux<MicrosoftGraphContractInner> listContractAsync(Integer top, Integer skip, String search, String filter, Boolean count, List<Get5ItemsItem> orderby, List<ContractsContractSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listContractSinglePageAsync(top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listMoreSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<MicrosoftGraphContractInner> listContract() {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<Get5ItemsItem> orderby = null;
        List<ContractsContractSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listContractAsync(top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    public PagedIterable<MicrosoftGraphContractInner> listContract(Integer top, Integer skip, String search, String filter, Boolean count, List<Get5ItemsItem> orderby, List<ContractsContractSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listContractAsync(top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    public Mono<Response<MicrosoftGraphContractInner>> createContractWithResponseAsync(MicrosoftGraphContractInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createContract(this.client.getEndpoint(), body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphContractInner>> createContractWithResponseAsync(MicrosoftGraphContractInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createContract(this.client.getEndpoint(), body, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphContractInner> createContractAsync(MicrosoftGraphContractInner body) {
        return this.createContractWithResponseAsync(body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphContractInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphContractInner createContract(MicrosoftGraphContractInner body) {
        return (MicrosoftGraphContractInner)this.createContractAsync(body).block();
    }

    @Override
    public Response<MicrosoftGraphContractInner> createContractWithResponse(MicrosoftGraphContractInner body, Context context) {
        return (Response)this.createContractWithResponseAsync(body, context).block();
    }

    @Override
    public Mono<Response<MicrosoftGraphContractInner>> getContractWithResponseAsync(String contractId, List<ContractsContractSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (contractId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contractId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getContract(this.client.getEndpoint(), contractId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphContractInner>> getContractWithResponseAsync(String contractId, List<ContractsContractSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (contractId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contractId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getContract(this.client.getEndpoint(), contractId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphContractInner> getContractAsync(String contractId, List<ContractsContractSelect> select, List<String> expand) {
        return this.getContractWithResponseAsync(contractId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphContractInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<MicrosoftGraphContractInner> getContractAsync(String contractId) {
        List<ContractsContractSelect> select = null;
        List<String> expand = null;
        return this.getContractWithResponseAsync(contractId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphContractInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphContractInner getContract(String contractId) {
        List<ContractsContractSelect> select = null;
        List<String> expand = null;
        return (MicrosoftGraphContractInner)this.getContractAsync(contractId, select, expand).block();
    }

    @Override
    public Response<MicrosoftGraphContractInner> getContractWithResponse(String contractId, List<ContractsContractSelect> select, List<String> expand, Context context) {
        return (Response)this.getContractWithResponseAsync(contractId, select, expand, context).block();
    }

    @Override
    public Mono<Response<Void>> updateContractWithResponseAsync(String contractId, MicrosoftGraphContractInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (contractId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contractId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateContract(this.client.getEndpoint(), contractId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> updateContractWithResponseAsync(String contractId, MicrosoftGraphContractInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (contractId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contractId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateContract(this.client.getEndpoint(), contractId, body, "application/json", context);
    }

    @Override
    public Mono<Void> updateContractAsync(String contractId, MicrosoftGraphContractInner body) {
        return this.updateContractWithResponseAsync(contractId, body).flatMap(res -> Mono.empty());
    }

    @Override
    public void updateContract(String contractId, MicrosoftGraphContractInner body) {
        this.updateContractAsync(contractId, body).block();
    }

    @Override
    public Response<Void> updateContractWithResponse(String contractId, MicrosoftGraphContractInner body, Context context) {
        return (Response)this.updateContractWithResponseAsync(contractId, body, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteContractWithResponseAsync(String contractId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (contractId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contractId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteContract(this.client.getEndpoint(), contractId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteContractWithResponseAsync(String contractId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (contractId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contractId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteContract(this.client.getEndpoint(), contractId, ifMatch, "application/json", context);
    }

    @Override
    public Mono<Void> deleteContractAsync(String contractId, String ifMatch) {
        return this.deleteContractWithResponseAsync(contractId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public Mono<Void> deleteContractAsync(String contractId) {
        String ifMatch = null;
        return this.deleteContractWithResponseAsync(contractId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public void deleteContract(String contractId) {
        String ifMatch = null;
        this.deleteContractAsync(contractId, ifMatch).block();
    }

    @Override
    public Response<Void> deleteContractWithResponse(String contractId, String ifMatch, Context context) {
        return (Response)this.deleteContractWithResponseAsync(contractId, ifMatch, context).block();
    }

    private Mono<PagedResponse<MicrosoftGraphContractInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listMore(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfContract)res.getValue()).value(), ((CollectionOfContract)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphContractInner>> listMoreSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listMore(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfContract)res.getValue()).value(), ((CollectionOfContract)res.getValue()).odataNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MicrosoftGraphClient")
    private static interface ContractsContractsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/contracts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfContract>> listContract(@HostParam(value="$host") String var1, @QueryParam(value="$top") Integer var2, @QueryParam(value="$skip") Integer var3, @QueryParam(value="$search") String var4, @QueryParam(value="$filter") String var5, @QueryParam(value="$count") Boolean var6, @QueryParam(value="$orderby") String var7, @QueryParam(value="$select") String var8, @QueryParam(value="$expand") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/contracts")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphContractInner>> createContract(@HostParam(value="$host") String var1, @BodyParam(value="application/json") MicrosoftGraphContractInner var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/contracts/{contract-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphContractInner>> getContract(@HostParam(value="$host") String var1, @PathParam(value="contract-id") String var2, @QueryParam(value="$select") String var3, @QueryParam(value="$expand") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/contracts/{contract-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateContract(@HostParam(value="$host") String var1, @PathParam(value="contract-id") String var2, @BodyParam(value="application/json") MicrosoftGraphContractInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/contracts/{contract-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteContract(@HostParam(value="$host") String var1, @PathParam(value="contract-id") String var2, @HeaderParam(value="If-Match") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfContract>> listMore(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

