/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.AuthorizationManagementClient;
import com.azure.resourcemanager.authorization.fluent.ClassicAdministratorsClient;
import com.azure.resourcemanager.authorization.fluent.GlobalAdministratorsClient;
import com.azure.resourcemanager.authorization.fluent.PermissionsClient;
import com.azure.resourcemanager.authorization.fluent.ProviderOperationsMetadatasClient;
import com.azure.resourcemanager.authorization.fluent.RoleAssignmentsClient;
import com.azure.resourcemanager.authorization.fluent.RoleDefinitionsClient;
import com.azure.resourcemanager.authorization.implementation.ClassicAdministratorsClientImpl;
import com.azure.resourcemanager.authorization.implementation.GlobalAdministratorsClientImpl;
import com.azure.resourcemanager.authorization.implementation.PermissionsClientImpl;
import com.azure.resourcemanager.authorization.implementation.ProviderOperationsMetadatasClientImpl;
import com.azure.resourcemanager.authorization.implementation.RoleAssignmentsClientImpl;
import com.azure.resourcemanager.authorization.implementation.RoleDefinitionsClientImpl;
import com.azure.resourcemanager.resources.fluentcore.AzureServiceClient;
import java.time.Duration;

public final class AuthorizationManagementClientImpl
extends AzureServiceClient
implements AuthorizationManagementClient {
    private final ClientLogger logger = new ClientLogger(AuthorizationManagementClientImpl.class);
    private final String subscriptionId;
    private final String endpoint;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final ClassicAdministratorsClient classicAdministrators;
    private final GlobalAdministratorsClient globalAdministrators;
    private final ProviderOperationsMetadatasClient providerOperationsMetadatas;
    private final RoleAssignmentsClient roleAssignments;
    private final PermissionsClient permissions;
    private final RoleDefinitionsClient roleDefinitions;

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public ClassicAdministratorsClient getClassicAdministrators() {
        return this.classicAdministrators;
    }

    @Override
    public GlobalAdministratorsClient getGlobalAdministrators() {
        return this.globalAdministrators;
    }

    @Override
    public ProviderOperationsMetadatasClient getProviderOperationsMetadatas() {
        return this.providerOperationsMetadatas;
    }

    @Override
    public RoleAssignmentsClient getRoleAssignments() {
        return this.roleAssignments;
    }

    @Override
    public PermissionsClient getPermissions() {
        return this.permissions;
    }

    @Override
    public RoleDefinitionsClient getRoleDefinitions() {
        return this.roleDefinitions;
    }

    AuthorizationManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        super(httpPipeline, serializerAdapter, environment);
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.classicAdministrators = new ClassicAdministratorsClientImpl(this);
        this.globalAdministrators = new GlobalAdministratorsClientImpl(this);
        this.providerOperationsMetadatas = new ProviderOperationsMetadatasClientImpl(this);
        this.roleAssignments = new RoleAssignmentsClientImpl(this);
        this.permissions = new PermissionsClientImpl(this);
        this.roleDefinitions = new RoleDefinitionsClientImpl(this);
    }
}

