/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.Contact;
import com.azure.resourcemanager.appservice.models.DnsType;
import com.azure.resourcemanager.appservice.models.DomainPurchaseConsent;
import com.azure.resourcemanager.appservice.models.DomainStatus;
import com.azure.resourcemanager.appservice.models.Hostname;
import com.azure.resourcemanager.appservice.models.ProvisioningState;
import com.azure.resourcemanager.appservice.models.ResourceNotRenewableReason;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class DomainPatchResourceProperties
implements JsonSerializable<DomainPatchResourceProperties> {
    private Contact contactAdmin;
    private Contact contactBilling;
    private Contact contactRegistrant;
    private Contact contactTech;
    private DomainStatus registrationStatus;
    private ProvisioningState provisioningState;
    private List<String> nameServers;
    private Boolean privacy;
    private OffsetDateTime createdTime;
    private OffsetDateTime expirationTime;
    private OffsetDateTime lastRenewedTime;
    private Boolean autoRenew;
    private Boolean readyForDnsRecordManagement;
    private List<Hostname> managedHostNames;
    private DomainPurchaseConsent consent;
    private List<ResourceNotRenewableReason> domainNotRenewableReasons;
    private DnsType dnsType;
    private String dnsZoneId;
    private DnsType targetDnsType;
    private String authCode;
    private static final ClientLogger LOGGER = new ClientLogger(DomainPatchResourceProperties.class);

    public Contact contactAdmin() {
        return this.contactAdmin;
    }

    public DomainPatchResourceProperties withContactAdmin(Contact contactAdmin) {
        this.contactAdmin = contactAdmin;
        return this;
    }

    public Contact contactBilling() {
        return this.contactBilling;
    }

    public DomainPatchResourceProperties withContactBilling(Contact contactBilling) {
        this.contactBilling = contactBilling;
        return this;
    }

    public Contact contactRegistrant() {
        return this.contactRegistrant;
    }

    public DomainPatchResourceProperties withContactRegistrant(Contact contactRegistrant) {
        this.contactRegistrant = contactRegistrant;
        return this;
    }

    public Contact contactTech() {
        return this.contactTech;
    }

    public DomainPatchResourceProperties withContactTech(Contact contactTech) {
        this.contactTech = contactTech;
        return this;
    }

    public DomainStatus registrationStatus() {
        return this.registrationStatus;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<String> nameServers() {
        return this.nameServers;
    }

    public Boolean privacy() {
        return this.privacy;
    }

    public DomainPatchResourceProperties withPrivacy(Boolean privacy) {
        this.privacy = privacy;
        return this;
    }

    public OffsetDateTime createdTime() {
        return this.createdTime;
    }

    public OffsetDateTime expirationTime() {
        return this.expirationTime;
    }

    public OffsetDateTime lastRenewedTime() {
        return this.lastRenewedTime;
    }

    public Boolean autoRenew() {
        return this.autoRenew;
    }

    public DomainPatchResourceProperties withAutoRenew(Boolean autoRenew) {
        this.autoRenew = autoRenew;
        return this;
    }

    public Boolean readyForDnsRecordManagement() {
        return this.readyForDnsRecordManagement;
    }

    public List<Hostname> managedHostNames() {
        return this.managedHostNames;
    }

    public DomainPurchaseConsent consent() {
        return this.consent;
    }

    public DomainPatchResourceProperties withConsent(DomainPurchaseConsent consent) {
        this.consent = consent;
        return this;
    }

    public List<ResourceNotRenewableReason> domainNotRenewableReasons() {
        return this.domainNotRenewableReasons;
    }

    public DnsType dnsType() {
        return this.dnsType;
    }

    public DomainPatchResourceProperties withDnsType(DnsType dnsType) {
        this.dnsType = dnsType;
        return this;
    }

    public String dnsZoneId() {
        return this.dnsZoneId;
    }

    public DomainPatchResourceProperties withDnsZoneId(String dnsZoneId) {
        this.dnsZoneId = dnsZoneId;
        return this;
    }

    public DnsType targetDnsType() {
        return this.targetDnsType;
    }

    public DomainPatchResourceProperties withTargetDnsType(DnsType targetDnsType) {
        this.targetDnsType = targetDnsType;
        return this;
    }

    public String authCode() {
        return this.authCode;
    }

    public DomainPatchResourceProperties withAuthCode(String authCode) {
        this.authCode = authCode;
        return this;
    }

    public void validate() {
        if (this.contactAdmin() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property contactAdmin in model DomainPatchResourceProperties"));
        }
        this.contactAdmin().validate();
        if (this.contactBilling() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property contactBilling in model DomainPatchResourceProperties"));
        }
        this.contactBilling().validate();
        if (this.contactRegistrant() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property contactRegistrant in model DomainPatchResourceProperties"));
        }
        this.contactRegistrant().validate();
        if (this.contactTech() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property contactTech in model DomainPatchResourceProperties"));
        }
        this.contactTech().validate();
        if (this.managedHostNames() != null) {
            this.managedHostNames().forEach(e -> e.validate());
        }
        if (this.consent() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property consent in model DomainPatchResourceProperties"));
        }
        this.consent().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("contactAdmin", (JsonSerializable)this.contactAdmin);
        jsonWriter.writeJsonField("contactBilling", (JsonSerializable)this.contactBilling);
        jsonWriter.writeJsonField("contactRegistrant", (JsonSerializable)this.contactRegistrant);
        jsonWriter.writeJsonField("contactTech", (JsonSerializable)this.contactTech);
        jsonWriter.writeJsonField("consent", (JsonSerializable)this.consent);
        jsonWriter.writeBooleanField("privacy", this.privacy);
        jsonWriter.writeBooleanField("autoRenew", this.autoRenew);
        jsonWriter.writeStringField("dnsType", this.dnsType == null ? null : this.dnsType.toString());
        jsonWriter.writeStringField("dnsZoneId", this.dnsZoneId);
        jsonWriter.writeStringField("targetDnsType", this.targetDnsType == null ? null : this.targetDnsType.toString());
        jsonWriter.writeStringField("authCode", this.authCode);
        return jsonWriter.writeEndObject();
    }

    public static DomainPatchResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DomainPatchResourceProperties)jsonReader.readObject(reader -> {
            DomainPatchResourceProperties deserializedDomainPatchResourceProperties = new DomainPatchResourceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("contactAdmin".equals(fieldName)) {
                    deserializedDomainPatchResourceProperties.contactAdmin = Contact.fromJson(reader);
                    continue;
                }
                if ("contactBilling".equals(fieldName)) {
                    deserializedDomainPatchResourceProperties.contactBilling = Contact.fromJson(reader);
                    continue;
                }
                if ("contactRegistrant".equals(fieldName)) {
                    deserializedDomainPatchResourceProperties.contactRegistrant = Contact.fromJson(reader);
                    continue;
                }
                if ("contactTech".equals(fieldName)) {
                    deserializedDomainPatchResourceProperties.contactTech = Contact.fromJson(reader);
                    continue;
                }
                if ("consent".equals(fieldName)) {
                    deserializedDomainPatchResourceProperties.consent = DomainPurchaseConsent.fromJson(reader);
                    continue;
                }
                if ("registrationStatus".equals(fieldName)) {
                    deserializedDomainPatchResourceProperties.registrationStatus = DomainStatus.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedDomainPatchResourceProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("nameServers".equals(fieldName)) {
                    List nameServers;
                    deserializedDomainPatchResourceProperties.nameServers = nameServers = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("privacy".equals(fieldName)) {
                    deserializedDomainPatchResourceProperties.privacy = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("createdTime".equals(fieldName)) {
                    deserializedDomainPatchResourceProperties.createdTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("expirationTime".equals(fieldName)) {
                    deserializedDomainPatchResourceProperties.expirationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastRenewedTime".equals(fieldName)) {
                    deserializedDomainPatchResourceProperties.lastRenewedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("autoRenew".equals(fieldName)) {
                    deserializedDomainPatchResourceProperties.autoRenew = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("readyForDnsRecordManagement".equals(fieldName)) {
                    deserializedDomainPatchResourceProperties.readyForDnsRecordManagement = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("managedHostNames".equals(fieldName)) {
                    List managedHostNames;
                    deserializedDomainPatchResourceProperties.managedHostNames = managedHostNames = reader.readArray(reader1 -> Hostname.fromJson(reader1));
                    continue;
                }
                if ("domainNotRenewableReasons".equals(fieldName)) {
                    List domainNotRenewableReasons;
                    deserializedDomainPatchResourceProperties.domainNotRenewableReasons = domainNotRenewableReasons = reader.readArray(reader1 -> ResourceNotRenewableReason.fromString(reader1.getString()));
                    continue;
                }
                if ("dnsType".equals(fieldName)) {
                    deserializedDomainPatchResourceProperties.dnsType = DnsType.fromString(reader.getString());
                    continue;
                }
                if ("dnsZoneId".equals(fieldName)) {
                    deserializedDomainPatchResourceProperties.dnsZoneId = reader.getString();
                    continue;
                }
                if ("targetDnsType".equals(fieldName)) {
                    deserializedDomainPatchResourceProperties.targetDnsType = DnsType.fromString(reader.getString());
                    continue;
                }
                if ("authCode".equals(fieldName)) {
                    deserializedDomainPatchResourceProperties.authCode = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDomainPatchResourceProperties;
        });
    }
}

