/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.WorkflowRunProperties;
import com.azure.resourcemanager.appservice.models.Correlation;
import com.azure.resourcemanager.appservice.models.ResourceReference;
import com.azure.resourcemanager.appservice.models.WorkflowOutputParameter;
import com.azure.resourcemanager.appservice.models.WorkflowRunTrigger;
import com.azure.resourcemanager.appservice.models.WorkflowStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class WorkflowRunInner
extends SubResource {
    private WorkflowRunProperties innerProperties;
    private String name;
    private String type;

    private WorkflowRunProperties innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public WorkflowRunInner withId(String id) {
        super.withId(id);
        return this;
    }

    public OffsetDateTime waitEndTime() {
        return this.innerProperties() == null ? null : this.innerProperties().waitEndTime();
    }

    public OffsetDateTime startTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startTime();
    }

    public OffsetDateTime endTime() {
        return this.innerProperties() == null ? null : this.innerProperties().endTime();
    }

    public WorkflowStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public String code() {
        return this.innerProperties() == null ? null : this.innerProperties().code();
    }

    public Object error() {
        return this.innerProperties() == null ? null : this.innerProperties().error();
    }

    public String correlationId() {
        return this.innerProperties() == null ? null : this.innerProperties().correlationId();
    }

    public Correlation correlation() {
        return this.innerProperties() == null ? null : this.innerProperties().correlation();
    }

    public WorkflowRunInner withCorrelation(Correlation correlation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkflowRunProperties();
        }
        this.innerProperties().withCorrelation(correlation);
        return this;
    }

    public ResourceReference workflow() {
        return this.innerProperties() == null ? null : this.innerProperties().workflow();
    }

    public WorkflowRunTrigger trigger() {
        return this.innerProperties() == null ? null : this.innerProperties().trigger();
    }

    public Map<String, WorkflowOutputParameter> outputs() {
        return this.innerProperties() == null ? null : this.innerProperties().outputs();
    }

    public WorkflowRunTrigger response() {
        return this.innerProperties() == null ? null : this.innerProperties().response();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static WorkflowRunInner fromJson(JsonReader jsonReader) throws IOException {
        return (WorkflowRunInner)((Object)jsonReader.readObject(reader -> {
            WorkflowRunInner deserializedWorkflowRunInner = new WorkflowRunInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedWorkflowRunInner.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedWorkflowRunInner.innerProperties = WorkflowRunProperties.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedWorkflowRunInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedWorkflowRunInner.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkflowRunInner;
        }));
    }
}

