/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.VnetRouteProperties;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.RouteType;
import java.io.IOException;

public final class VnetRouteInner
extends ProxyOnlyResource {
    private VnetRouteProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private VnetRouteProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public VnetRouteInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public String startAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().startAddress();
    }

    public VnetRouteInner withStartAddress(String startAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VnetRouteProperties();
        }
        this.innerProperties().withStartAddress(startAddress);
        return this;
    }

    public String endAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().endAddress();
    }

    public VnetRouteInner withEndAddress(String endAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VnetRouteProperties();
        }
        this.innerProperties().withEndAddress(endAddress);
        return this;
    }

    public RouteType routeType() {
        return this.innerProperties() == null ? null : this.innerProperties().routeType();
    }

    public VnetRouteInner withRouteType(RouteType routeType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VnetRouteProperties();
        }
        this.innerProperties().withRouteType(routeType);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static VnetRouteInner fromJson(JsonReader jsonReader) throws IOException {
        return (VnetRouteInner)((Object)jsonReader.readObject(reader -> {
            VnetRouteInner deserializedVnetRouteInner = new VnetRouteInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedVnetRouteInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedVnetRouteInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVnetRouteInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedVnetRouteInner.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVnetRouteInner.innerProperties = VnetRouteProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVnetRouteInner;
        }));
    }
}

