/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.RenderingType;
import java.io.IOException;

public final class Rendering
implements JsonSerializable<Rendering> {
    private RenderingType type;
    private String title;
    private String description;

    public RenderingType type() {
        return this.type;
    }

    public Rendering withType(RenderingType type) {
        this.type = type;
        return this;
    }

    public String title() {
        return this.title;
    }

    public Rendering withTitle(String title) {
        this.title = title;
        return this;
    }

    public String description() {
        return this.description;
    }

    public Rendering withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("title", this.title);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static Rendering fromJson(JsonReader jsonReader) throws IOException {
        return (Rendering)jsonReader.readObject(reader -> {
            Rendering deserializedRendering = new Rendering();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedRendering.type = RenderingType.fromString(reader.getString());
                    continue;
                }
                if ("title".equals(fieldName)) {
                    deserializedRendering.title = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedRendering.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRendering;
        });
    }
}

