/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.WebSiteInstanceStatusProperties;
import com.azure.resourcemanager.appservice.models.ContainerInfo;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.SiteRuntimeState;
import java.io.IOException;
import java.util.Map;

public final class WebSiteInstanceStatusInner
extends ProxyOnlyResource {
    private WebSiteInstanceStatusProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private WebSiteInstanceStatusProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public WebSiteInstanceStatusInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public SiteRuntimeState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    public WebSiteInstanceStatusInner withState(SiteRuntimeState state) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebSiteInstanceStatusProperties();
        }
        this.innerProperties().withState(state);
        return this;
    }

    public String statusUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().statusUrl();
    }

    public WebSiteInstanceStatusInner withStatusUrl(String statusUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebSiteInstanceStatusProperties();
        }
        this.innerProperties().withStatusUrl(statusUrl);
        return this;
    }

    public String detectorUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().detectorUrl();
    }

    public WebSiteInstanceStatusInner withDetectorUrl(String detectorUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebSiteInstanceStatusProperties();
        }
        this.innerProperties().withDetectorUrl(detectorUrl);
        return this;
    }

    public String consoleUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().consoleUrl();
    }

    public WebSiteInstanceStatusInner withConsoleUrl(String consoleUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebSiteInstanceStatusProperties();
        }
        this.innerProperties().withConsoleUrl(consoleUrl);
        return this;
    }

    public String healthCheckUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().healthCheckUrl();
    }

    public WebSiteInstanceStatusInner withHealthCheckUrl(String healthCheckUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebSiteInstanceStatusProperties();
        }
        this.innerProperties().withHealthCheckUrl(healthCheckUrl);
        return this;
    }

    public Map<String, ContainerInfo> containers() {
        return this.innerProperties() == null ? null : this.innerProperties().containers();
    }

    public WebSiteInstanceStatusInner withContainers(Map<String, ContainerInfo> containers) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebSiteInstanceStatusProperties();
        }
        this.innerProperties().withContainers(containers);
        return this;
    }

    public String physicalZone() {
        return this.innerProperties() == null ? null : this.innerProperties().physicalZone();
    }

    public WebSiteInstanceStatusInner withPhysicalZone(String physicalZone) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebSiteInstanceStatusProperties();
        }
        this.innerProperties().withPhysicalZone(physicalZone);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static WebSiteInstanceStatusInner fromJson(JsonReader jsonReader) throws IOException {
        return (WebSiteInstanceStatusInner)((Object)jsonReader.readObject(reader -> {
            WebSiteInstanceStatusInner deserializedWebSiteInstanceStatusInner = new WebSiteInstanceStatusInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedWebSiteInstanceStatusInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedWebSiteInstanceStatusInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedWebSiteInstanceStatusInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedWebSiteInstanceStatusInner.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedWebSiteInstanceStatusInner.innerProperties = WebSiteInstanceStatusProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebSiteInstanceStatusInner;
        }));
    }
}

