/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class DeploymentProperties
implements JsonSerializable<DeploymentProperties> {
    private Integer status;
    private String message;
    private String author;
    private String deployer;
    private String authorEmail;
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private Boolean active;
    private String details;

    public Integer status() {
        return this.status;
    }

    public DeploymentProperties withStatus(Integer status) {
        this.status = status;
        return this;
    }

    public String message() {
        return this.message;
    }

    public DeploymentProperties withMessage(String message) {
        this.message = message;
        return this;
    }

    public String author() {
        return this.author;
    }

    public DeploymentProperties withAuthor(String author) {
        this.author = author;
        return this;
    }

    public String deployer() {
        return this.deployer;
    }

    public DeploymentProperties withDeployer(String deployer) {
        this.deployer = deployer;
        return this;
    }

    public String authorEmail() {
        return this.authorEmail;
    }

    public DeploymentProperties withAuthorEmail(String authorEmail) {
        this.authorEmail = authorEmail;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public DeploymentProperties withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public DeploymentProperties withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public Boolean active() {
        return this.active;
    }

    public DeploymentProperties withActive(Boolean active) {
        this.active = active;
        return this;
    }

    public String details() {
        return this.details;
    }

    public DeploymentProperties withDetails(String details) {
        this.details = details;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("status", (Number)this.status);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("author", this.author);
        jsonWriter.writeStringField("deployer", this.deployer);
        jsonWriter.writeStringField("author_email", this.authorEmail);
        jsonWriter.writeStringField("start_time", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("end_time", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeBooleanField("active", this.active);
        jsonWriter.writeStringField("details", this.details);
        return jsonWriter.writeEndObject();
    }

    public static DeploymentProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DeploymentProperties)jsonReader.readObject(reader -> {
            DeploymentProperties deserializedDeploymentProperties = new DeploymentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedDeploymentProperties.status = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedDeploymentProperties.message = reader.getString();
                    continue;
                }
                if ("author".equals(fieldName)) {
                    deserializedDeploymentProperties.author = reader.getString();
                    continue;
                }
                if ("deployer".equals(fieldName)) {
                    deserializedDeploymentProperties.deployer = reader.getString();
                    continue;
                }
                if ("author_email".equals(fieldName)) {
                    deserializedDeploymentProperties.authorEmail = reader.getString();
                    continue;
                }
                if ("start_time".equals(fieldName)) {
                    deserializedDeploymentProperties.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("end_time".equals(fieldName)) {
                    deserializedDeploymentProperties.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("active".equals(fieldName)) {
                    deserializedDeploymentProperties.active = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("details".equals(fieldName)) {
                    deserializedDeploymentProperties.details = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeploymentProperties;
        });
    }
}

