/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class SiteDnsConfig
implements JsonSerializable<SiteDnsConfig> {
    private List<String> dnsServers;
    private String dnsAltServer;
    private Integer dnsRetryAttemptTimeout;
    private Integer dnsRetryAttemptCount;
    private Integer dnsMaxCacheTimeout;
    private Boolean dnsLegacySortOrder;

    public List<String> dnsServers() {
        return this.dnsServers;
    }

    public SiteDnsConfig withDnsServers(List<String> dnsServers) {
        this.dnsServers = dnsServers;
        return this;
    }

    public String dnsAltServer() {
        return this.dnsAltServer;
    }

    public SiteDnsConfig withDnsAltServer(String dnsAltServer) {
        this.dnsAltServer = dnsAltServer;
        return this;
    }

    public Integer dnsRetryAttemptTimeout() {
        return this.dnsRetryAttemptTimeout;
    }

    public SiteDnsConfig withDnsRetryAttemptTimeout(Integer dnsRetryAttemptTimeout) {
        this.dnsRetryAttemptTimeout = dnsRetryAttemptTimeout;
        return this;
    }

    public Integer dnsRetryAttemptCount() {
        return this.dnsRetryAttemptCount;
    }

    public SiteDnsConfig withDnsRetryAttemptCount(Integer dnsRetryAttemptCount) {
        this.dnsRetryAttemptCount = dnsRetryAttemptCount;
        return this;
    }

    public Integer dnsMaxCacheTimeout() {
        return this.dnsMaxCacheTimeout;
    }

    public SiteDnsConfig withDnsMaxCacheTimeout(Integer dnsMaxCacheTimeout) {
        this.dnsMaxCacheTimeout = dnsMaxCacheTimeout;
        return this;
    }

    public Boolean dnsLegacySortOrder() {
        return this.dnsLegacySortOrder;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("dnsServers", this.dnsServers, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("dnsAltServer", this.dnsAltServer);
        jsonWriter.writeNumberField("dnsRetryAttemptTimeout", (Number)this.dnsRetryAttemptTimeout);
        jsonWriter.writeNumberField("dnsRetryAttemptCount", (Number)this.dnsRetryAttemptCount);
        jsonWriter.writeNumberField("dnsMaxCacheTimeout", (Number)this.dnsMaxCacheTimeout);
        return jsonWriter.writeEndObject();
    }

    public static SiteDnsConfig fromJson(JsonReader jsonReader) throws IOException {
        return (SiteDnsConfig)jsonReader.readObject(reader -> {
            SiteDnsConfig deserializedSiteDnsConfig = new SiteDnsConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dnsServers".equals(fieldName)) {
                    List dnsServers;
                    deserializedSiteDnsConfig.dnsServers = dnsServers = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("dnsAltServer".equals(fieldName)) {
                    deserializedSiteDnsConfig.dnsAltServer = reader.getString();
                    continue;
                }
                if ("dnsRetryAttemptTimeout".equals(fieldName)) {
                    deserializedSiteDnsConfig.dnsRetryAttemptTimeout = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("dnsRetryAttemptCount".equals(fieldName)) {
                    deserializedSiteDnsConfig.dnsRetryAttemptCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("dnsMaxCacheTimeout".equals(fieldName)) {
                    deserializedSiteDnsConfig.dnsMaxCacheTimeout = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("dnsLegacySortOrder".equals(fieldName)) {
                    deserializedSiteDnsConfig.dnsLegacySortOrder = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSiteDnsConfig;
        });
    }
}

