/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.NameIdentifierInner;
import java.io.IOException;
import java.util.List;

public final class NameIdentifierCollection
implements JsonSerializable<NameIdentifierCollection> {
    private List<NameIdentifierInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(NameIdentifierCollection.class);

    public List<NameIdentifierInner> value() {
        return this.value;
    }

    public NameIdentifierCollection withValue(List<NameIdentifierInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model NameIdentifierCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static NameIdentifierCollection fromJson(JsonReader jsonReader) throws IOException {
        return (NameIdentifierCollection)jsonReader.readObject(reader -> {
            NameIdentifierCollection deserializedNameIdentifierCollection = new NameIdentifierCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedNameIdentifierCollection.value = value = reader.readArray(reader1 -> NameIdentifierInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedNameIdentifierCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNameIdentifierCollection;
        });
    }
}

