/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.HybridConnectionInner;
import java.io.IOException;
import java.util.List;

public final class HybridConnectionCollection
implements JsonSerializable<HybridConnectionCollection> {
    private List<HybridConnectionInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(HybridConnectionCollection.class);

    public List<HybridConnectionInner> value() {
        return this.value;
    }

    public HybridConnectionCollection withValue(List<HybridConnectionInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model HybridConnectionCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static HybridConnectionCollection fromJson(JsonReader jsonReader) throws IOException {
        return (HybridConnectionCollection)jsonReader.readObject(reader -> {
            HybridConnectionCollection deserializedHybridConnectionCollection = new HybridConnectionCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedHybridConnectionCollection.value = value = reader.readArray(reader1 -> HybridConnectionInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedHybridConnectionCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHybridConnectionCollection;
        });
    }
}

