/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.DetectorType;
import com.azure.resourcemanager.appservice.models.SupportTopic;
import java.io.IOException;
import java.util.List;

public final class DetectorInfo
implements JsonSerializable<DetectorInfo> {
    private String id;
    private String name;
    private String description;
    private String author;
    private String category;
    private List<SupportTopic> supportTopicList;
    private List<String> analysisType;
    private DetectorType type;
    private Float score;

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String author() {
        return this.author;
    }

    public String category() {
        return this.category;
    }

    public List<SupportTopic> supportTopicList() {
        return this.supportTopicList;
    }

    public List<String> analysisType() {
        return this.analysisType;
    }

    public DetectorType type() {
        return this.type;
    }

    public Float score() {
        return this.score;
    }

    public void validate() {
        if (this.supportTopicList() != null) {
            this.supportTopicList().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static DetectorInfo fromJson(JsonReader jsonReader) throws IOException {
        return (DetectorInfo)jsonReader.readObject(reader -> {
            DetectorInfo deserializedDetectorInfo = new DetectorInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDetectorInfo.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDetectorInfo.name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedDetectorInfo.description = reader.getString();
                    continue;
                }
                if ("author".equals(fieldName)) {
                    deserializedDetectorInfo.author = reader.getString();
                    continue;
                }
                if ("category".equals(fieldName)) {
                    deserializedDetectorInfo.category = reader.getString();
                    continue;
                }
                if ("supportTopicList".equals(fieldName)) {
                    List supportTopicList;
                    deserializedDetectorInfo.supportTopicList = supportTopicList = reader.readArray(reader1 -> SupportTopic.fromJson(reader1));
                    continue;
                }
                if ("analysisType".equals(fieldName)) {
                    List analysisType;
                    deserializedDetectorInfo.analysisType = analysisType = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDetectorInfo.type = DetectorType.fromString(reader.getString());
                    continue;
                }
                if ("score".equals(fieldName)) {
                    deserializedDetectorInfo.score = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDetectorInfo;
        });
    }
}

