/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.DatabaseType;
import java.io.IOException;

public final class DatabaseBackupSetting
implements JsonSerializable<DatabaseBackupSetting> {
    private DatabaseType databaseType;
    private String name;
    private String connectionStringName;
    private String connectionString;
    private static final ClientLogger LOGGER = new ClientLogger(DatabaseBackupSetting.class);

    public DatabaseType databaseType() {
        return this.databaseType;
    }

    public DatabaseBackupSetting withDatabaseType(DatabaseType databaseType) {
        this.databaseType = databaseType;
        return this;
    }

    public String name() {
        return this.name;
    }

    public DatabaseBackupSetting withName(String name) {
        this.name = name;
        return this;
    }

    public String connectionStringName() {
        return this.connectionStringName;
    }

    public DatabaseBackupSetting withConnectionStringName(String connectionStringName) {
        this.connectionStringName = connectionStringName;
        return this;
    }

    public String connectionString() {
        return this.connectionString;
    }

    public DatabaseBackupSetting withConnectionString(String connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public void validate() {
        if (this.databaseType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property databaseType in model DatabaseBackupSetting"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("databaseType", this.databaseType == null ? null : this.databaseType.toString());
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("connectionStringName", this.connectionStringName);
        jsonWriter.writeStringField("connectionString", this.connectionString);
        return jsonWriter.writeEndObject();
    }

    public static DatabaseBackupSetting fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseBackupSetting)jsonReader.readObject(reader -> {
            DatabaseBackupSetting deserializedDatabaseBackupSetting = new DatabaseBackupSetting();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("databaseType".equals(fieldName)) {
                    deserializedDatabaseBackupSetting.databaseType = DatabaseType.fromString(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDatabaseBackupSetting.name = reader.getString();
                    continue;
                }
                if ("connectionStringName".equals(fieldName)) {
                    deserializedDatabaseBackupSetting.connectionStringName = reader.getString();
                    continue;
                }
                if ("connectionString".equals(fieldName)) {
                    deserializedDatabaseBackupSetting.connectionString = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseBackupSetting;
        });
    }
}

