/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.DefaultAuthorizationPolicy;
import com.azure.resourcemanager.appservice.models.JwtClaimChecks;
import java.io.IOException;
import java.util.List;

public final class AzureActiveDirectoryValidation
implements JsonSerializable<AzureActiveDirectoryValidation> {
    private JwtClaimChecks jwtClaimChecks;
    private List<String> allowedAudiences;
    private DefaultAuthorizationPolicy defaultAuthorizationPolicy;

    public JwtClaimChecks jwtClaimChecks() {
        return this.jwtClaimChecks;
    }

    public AzureActiveDirectoryValidation withJwtClaimChecks(JwtClaimChecks jwtClaimChecks) {
        this.jwtClaimChecks = jwtClaimChecks;
        return this;
    }

    public List<String> allowedAudiences() {
        return this.allowedAudiences;
    }

    public AzureActiveDirectoryValidation withAllowedAudiences(List<String> allowedAudiences) {
        this.allowedAudiences = allowedAudiences;
        return this;
    }

    public DefaultAuthorizationPolicy defaultAuthorizationPolicy() {
        return this.defaultAuthorizationPolicy;
    }

    public AzureActiveDirectoryValidation withDefaultAuthorizationPolicy(DefaultAuthorizationPolicy defaultAuthorizationPolicy) {
        this.defaultAuthorizationPolicy = defaultAuthorizationPolicy;
        return this;
    }

    public void validate() {
        if (this.jwtClaimChecks() != null) {
            this.jwtClaimChecks().validate();
        }
        if (this.defaultAuthorizationPolicy() != null) {
            this.defaultAuthorizationPolicy().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("jwtClaimChecks", (JsonSerializable)this.jwtClaimChecks);
        jsonWriter.writeArrayField("allowedAudiences", this.allowedAudiences, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("defaultAuthorizationPolicy", (JsonSerializable)this.defaultAuthorizationPolicy);
        return jsonWriter.writeEndObject();
    }

    public static AzureActiveDirectoryValidation fromJson(JsonReader jsonReader) throws IOException {
        return (AzureActiveDirectoryValidation)jsonReader.readObject(reader -> {
            AzureActiveDirectoryValidation deserializedAzureActiveDirectoryValidation = new AzureActiveDirectoryValidation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("jwtClaimChecks".equals(fieldName)) {
                    deserializedAzureActiveDirectoryValidation.jwtClaimChecks = JwtClaimChecks.fromJson(reader);
                    continue;
                }
                if ("allowedAudiences".equals(fieldName)) {
                    List allowedAudiences;
                    deserializedAzureActiveDirectoryValidation.allowedAudiences = allowedAudiences = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("defaultAuthorizationPolicy".equals(fieldName)) {
                    deserializedAzureActiveDirectoryValidation.defaultAuthorizationPolicy = DefaultAuthorizationPolicy.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureActiveDirectoryValidation;
        });
    }
}

