/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.AppServiceEnvironmentResourceInner;
import java.io.IOException;
import java.util.List;

public final class AppServiceEnvironmentCollection
implements JsonSerializable<AppServiceEnvironmentCollection> {
    private List<AppServiceEnvironmentResourceInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(AppServiceEnvironmentCollection.class);

    public List<AppServiceEnvironmentResourceInner> value() {
        return this.value;
    }

    public AppServiceEnvironmentCollection withValue(List<AppServiceEnvironmentResourceInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model AppServiceEnvironmentCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AppServiceEnvironmentCollection fromJson(JsonReader jsonReader) throws IOException {
        return (AppServiceEnvironmentCollection)jsonReader.readObject(reader -> {
            AppServiceEnvironmentCollection deserializedAppServiceEnvironmentCollection = new AppServiceEnvironmentCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedAppServiceEnvironmentCollection.value = value = reader.readArray(reader1 -> AppServiceEnvironmentResourceInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedAppServiceEnvironmentCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAppServiceEnvironmentCollection;
        });
    }
}

