/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.DetectorAbnormalTimePeriod;
import com.azure.resourcemanager.appservice.models.Solution;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class AbnormalTimePeriod
implements JsonSerializable<AbnormalTimePeriod> {
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private List<DetectorAbnormalTimePeriod> events;
    private List<Solution> solutions;

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public AbnormalTimePeriod withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public AbnormalTimePeriod withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public List<DetectorAbnormalTimePeriod> events() {
        return this.events;
    }

    public AbnormalTimePeriod withEvents(List<DetectorAbnormalTimePeriod> events) {
        this.events = events;
        return this;
    }

    public List<Solution> solutions() {
        return this.solutions;
    }

    public AbnormalTimePeriod withSolutions(List<Solution> solutions) {
        this.solutions = solutions;
        return this;
    }

    public void validate() {
        if (this.events() != null) {
            this.events().forEach(e -> e.validate());
        }
        if (this.solutions() != null) {
            this.solutions().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeArrayField("events", this.events, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("solutions", this.solutions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AbnormalTimePeriod fromJson(JsonReader jsonReader) throws IOException {
        return (AbnormalTimePeriod)jsonReader.readObject(reader -> {
            AbnormalTimePeriod deserializedAbnormalTimePeriod = new AbnormalTimePeriod();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startTime".equals(fieldName)) {
                    deserializedAbnormalTimePeriod.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedAbnormalTimePeriod.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("events".equals(fieldName)) {
                    List events;
                    deserializedAbnormalTimePeriod.events = events = reader.readArray(reader1 -> DetectorAbnormalTimePeriod.fromJson(reader1));
                    continue;
                }
                if ("solutions".equals(fieldName)) {
                    List solutions;
                    deserializedAbnormalTimePeriod.solutions = solutions = reader.readArray(reader1 -> Solution.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAbnormalTimePeriod;
        });
    }
}

