/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.serializer.SerializerFactory;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.azure.resourcemanager.appservice.fluent.models.HostKeysInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteConfigResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteLogsConfigInner;
import com.azure.resourcemanager.appservice.fluent.models.SitePatchResourceInner;
import com.azure.resourcemanager.appservice.implementation.DeploymentSlotBaseImpl;
import com.azure.resourcemanager.appservice.implementation.FunctionAppImpl;
import com.azure.resourcemanager.appservice.implementation.HttpFluxBBResponse;
import com.azure.resourcemanager.appservice.implementation.WebAppBaseImpl;
import com.azure.resourcemanager.appservice.models.CsmDeploymentStatus;
import com.azure.resourcemanager.appservice.models.DeployOptions;
import com.azure.resourcemanager.appservice.models.DeployType;
import com.azure.resourcemanager.appservice.models.DeploymentSlotBase;
import com.azure.resourcemanager.appservice.models.FunctionApp;
import com.azure.resourcemanager.appservice.models.FunctionDeploymentSlot;
import com.azure.resourcemanager.appservice.models.KuduDeploymentResult;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class FunctionDeploymentSlotImpl
extends DeploymentSlotBaseImpl<FunctionDeploymentSlot, FunctionDeploymentSlotImpl, FunctionAppImpl, FunctionDeploymentSlot.DefinitionStages.WithCreate, DeploymentSlotBase<FunctionDeploymentSlot>>
implements FunctionDeploymentSlot,
FunctionDeploymentSlot.Definition {
    private static final ClientLogger LOGGER = new ClientLogger(FunctionDeploymentSlotImpl.class);
    private Boolean appServicePlanIsFlexConsumption;

    FunctionDeploymentSlotImpl(String name, SiteInner innerObject, SiteConfigResourceInner siteConfig, SiteLogsConfigInner logConfig, FunctionAppImpl parent) {
        super(name, innerObject, siteConfig, logConfig, parent);
    }

    @Override
    public FunctionDeploymentSlot.DefinitionStages.WithCreate withConfigurationFromParent() {
        return this.withConfigurationFromFunctionApp((FunctionApp)this.parent());
    }

    @Override
    public FunctionDeploymentSlot.DefinitionStages.WithCreate withConfigurationFromFunctionApp(FunctionApp app) {
        this.siteConfig = ((WebAppBaseImpl)((Object)app)).siteConfig;
        this.configurationSource = app;
        return this;
    }

    @Override
    public void zipDeploy(File zipFile) {
        this.zipDeployAsync(zipFile).block();
    }

    @Override
    public void zipDeploy(InputStream zipFile, long length) {
        this.zipDeployAsync(zipFile, length).block();
    }

    @Override
    public Mono<Void> zipDeployAsync(InputStream zipFile, long length) {
        return this.kuduClient.zipDeployAsync(zipFile, length);
    }

    @Override
    public Mono<Void> zipDeployAsync(File zipFile) {
        try {
            return this.kuduClient.zipDeployAsync(zipFile);
        }
        catch (IOException e) {
            return Mono.error((Throwable)e);
        }
    }

    @Override
    Mono<SiteInner> submitSite(SiteInner site) {
        return this.submitSiteWithoutSiteConfig(site);
    }

    @Override
    Mono<SiteInner> submitSite(SitePatchResourceInner siteUpdate) {
        return this.submitSiteWithoutSiteConfig((SiteInner)((Object)this.innerModel()));
    }

    @Override
    public String getMasterKey() {
        return (String)this.getMasterKeyAsync().block();
    }

    @Override
    public Mono<String> getMasterKeyAsync() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().listHostKeysSlotAsync(this.resourceGroupName(), ((FunctionAppImpl)this.parent()).name(), this.name()).map(HostKeysInner::masterKey);
    }

    @Override
    public void deploy(DeployType type, File file) {
        this.deployAsync(type, file).block();
    }

    @Override
    public Mono<Void> deployAsync(DeployType type, File file) {
        return this.deployAsync(type, file, null);
    }

    @Override
    public void deploy(DeployType type, File file, DeployOptions deployOptions) {
        this.deployAsync(type, file, null).block();
    }

    @Override
    public Mono<Void> deployAsync(DeployType type, File file, DeployOptions deployOptions) {
        return this.pushDeployAsync(type, file, null).flatMap(result -> this.kuduClient.pollDeploymentStatus((KuduDeploymentResult)result, ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getDefaultPollInterval()));
    }

    @Override
    public void deploy(DeployType type, InputStream file, long length) {
        this.deployAsync(type, file, length).block();
    }

    @Override
    public Mono<Void> deployAsync(DeployType type, InputStream file, long length) {
        return this.deployAsync(type, file, length, null);
    }

    @Override
    public void deploy(DeployType type, InputStream file, long length, DeployOptions deployOptions) {
        this.deployAsync(type, file, length, null).block();
    }

    @Override
    public Mono<Void> deployAsync(DeployType type, InputStream file, long length, DeployOptions deployOptions) {
        return this.pushDeployAsync(type, file, length, null).flatMap(result -> this.kuduClient.pollDeploymentStatus((KuduDeploymentResult)result, ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getDefaultPollInterval()));
    }

    @Override
    public KuduDeploymentResult pushDeploy(DeployType type, File file, DeployOptions deployOptions) {
        return (KuduDeploymentResult)this.pushDeployAsync(type, file, deployOptions).block();
    }

    @Override
    public Mono<KuduDeploymentResult> pushDeployAsync(DeployType type, File file, DeployOptions deployOptions) {
        if (type != DeployType.ZIP) {
            return Mono.error((Throwable)new IllegalArgumentException("Deployment to Function App supports ZIP package."));
        }
        return this.getAppServicePlanIsFlexConsumptionMono().flatMap(appServiceIsFlexConsumptionPlan -> {
            try {
                if (appServiceIsFlexConsumptionPlan.booleanValue()) {
                    return this.kuduClient.pushDeployFlexConsumptionAsync(file);
                }
                return this.kuduClient.pushZipDeployAsync(file).then(Mono.just((Object)new KuduDeploymentResult("latest")));
            }
            catch (IOException e) {
                return Mono.error((Throwable)e);
            }
        });
    }

    private Mono<KuduDeploymentResult> pushDeployAsync(DeployType type, InputStream file, long length, DeployOptions deployOptions) {
        if (type != DeployType.ZIP) {
            return Mono.error((Throwable)new IllegalArgumentException("Deployment to Function App supports ZIP package."));
        }
        return this.getAppServicePlanIsFlexConsumptionMono().flatMap(appServiceIsFlexConsumptionPlan -> {
            try {
                if (appServiceIsFlexConsumptionPlan.booleanValue()) {
                    return this.kuduClient.pushDeployFlexConsumptionAsync(file, length);
                }
                return this.kuduClient.pushZipDeployAsync(file, length).then(Mono.just((Object)new KuduDeploymentResult("latest")));
            }
            catch (IOException e) {
                return Mono.error((Throwable)e);
            }
        });
    }

    private Mono<Boolean> getAppServicePlanIsFlexConsumptionMono() {
        Mono updateAppServicePlan = Mono.justOrEmpty((Object)this.appServicePlanIsFlexConsumption);
        if (this.appServicePlanIsFlexConsumption == null) {
            updateAppServicePlan = Mono.defer(() -> ((AppServiceManager)this.manager()).appServicePlans().getByIdAsync(this.appServicePlanId()).map(appServicePlan -> {
                this.appServicePlanIsFlexConsumption = "FlexConsumption".equals(appServicePlan.pricingTier().toSkuDescription().tier());
                return this.appServicePlanIsFlexConsumption;
            }));
        }
        return updateAppServicePlan;
    }

    @Override
    public CsmDeploymentStatus getDeploymentStatus(String deploymentId) {
        return (CsmDeploymentStatus)((Object)this.getDeploymentStatusAsync(deploymentId).block());
    }

    @Override
    public Mono<CsmDeploymentStatus> getDeploymentStatusAsync(String deploymentId) {
        SerializerAdapter serializerAdapter = SerializerFactory.createDefaultManagementSerializerAdapter();
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().getSlotSiteDeploymentStatusSlotWithResponseAsync(this.resourceGroupName(), ((FunctionAppImpl)this.parent()).name(), this.name(), deploymentId).flatMap(fluxResponse -> {
            HttpFluxBBResponse response = new HttpFluxBBResponse((Response<Flux<ByteBuffer>>)fluxResponse);
            return response.getBodyAsString().flatMap(bodyString -> {
                CsmDeploymentStatus status;
                try {
                    status = (CsmDeploymentStatus)((Object)((Object)((Object)serializerAdapter.deserialize(bodyString, CsmDeploymentStatus.class, SerializerEncoding.JSON))));
                }
                catch (IOException e) {
                    return Mono.error((Throwable)new ManagementException("Deserialize failed for response body.", response));
                }
                return Mono.justOrEmpty((Object)((Object)status));
            }).doFinally(ignored -> response.close());
        });
    }
}

