/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ComputeModeOptions;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class UsageProperties
implements JsonSerializable<UsageProperties> {
    private String displayName;
    private String resourceName;
    private String unit;
    private Long currentValue;
    private Long limit;
    private OffsetDateTime nextResetTime;
    private ComputeModeOptions computeMode;
    private String siteMode;

    public String displayName() {
        return this.displayName;
    }

    public String resourceName() {
        return this.resourceName;
    }

    public String unit() {
        return this.unit;
    }

    public Long currentValue() {
        return this.currentValue;
    }

    public Long limit() {
        return this.limit;
    }

    public OffsetDateTime nextResetTime() {
        return this.nextResetTime;
    }

    public ComputeModeOptions computeMode() {
        return this.computeMode;
    }

    public String siteMode() {
        return this.siteMode;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static UsageProperties fromJson(JsonReader jsonReader) throws IOException {
        return (UsageProperties)jsonReader.readObject(reader -> {
            UsageProperties deserializedUsageProperties = new UsageProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("displayName".equals(fieldName)) {
                    deserializedUsageProperties.displayName = reader.getString();
                    continue;
                }
                if ("resourceName".equals(fieldName)) {
                    deserializedUsageProperties.resourceName = reader.getString();
                    continue;
                }
                if ("unit".equals(fieldName)) {
                    deserializedUsageProperties.unit = reader.getString();
                    continue;
                }
                if ("currentValue".equals(fieldName)) {
                    deserializedUsageProperties.currentValue = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("limit".equals(fieldName)) {
                    deserializedUsageProperties.limit = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("nextResetTime".equals(fieldName)) {
                    deserializedUsageProperties.nextResetTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("computeMode".equals(fieldName)) {
                    deserializedUsageProperties.computeMode = ComputeModeOptions.fromString(reader.getString());
                    continue;
                }
                if ("siteMode".equals(fieldName)) {
                    deserializedUsageProperties.siteMode = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUsageProperties;
        });
    }
}

