/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.AuthType;
import com.azure.resourcemanager.appservice.models.EnvironmentVariable;
import com.azure.resourcemanager.appservice.models.VolumeMount;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class SiteContainerProperties
implements JsonSerializable<SiteContainerProperties> {
    private String image;
    private String targetPort;
    private boolean isMain;
    private String startUpCommand;
    private AuthType authType;
    private String username;
    private String passwordSecret;
    private String userManagedIdentityClientId;
    private OffsetDateTime createdTime;
    private OffsetDateTime lastModifiedTime;
    private List<VolumeMount> volumeMounts;
    private List<EnvironmentVariable> environmentVariables;
    private static final ClientLogger LOGGER = new ClientLogger(SiteContainerProperties.class);

    public String image() {
        return this.image;
    }

    public SiteContainerProperties withImage(String image) {
        this.image = image;
        return this;
    }

    public String targetPort() {
        return this.targetPort;
    }

    public SiteContainerProperties withTargetPort(String targetPort) {
        this.targetPort = targetPort;
        return this;
    }

    public boolean isMain() {
        return this.isMain;
    }

    public SiteContainerProperties withIsMain(boolean isMain) {
        this.isMain = isMain;
        return this;
    }

    public String startUpCommand() {
        return this.startUpCommand;
    }

    public SiteContainerProperties withStartUpCommand(String startUpCommand) {
        this.startUpCommand = startUpCommand;
        return this;
    }

    public AuthType authType() {
        return this.authType;
    }

    public SiteContainerProperties withAuthType(AuthType authType) {
        this.authType = authType;
        return this;
    }

    public String username() {
        return this.username;
    }

    public SiteContainerProperties withUsername(String username) {
        this.username = username;
        return this;
    }

    public String passwordSecret() {
        return this.passwordSecret;
    }

    public SiteContainerProperties withPasswordSecret(String passwordSecret) {
        this.passwordSecret = passwordSecret;
        return this;
    }

    public String userManagedIdentityClientId() {
        return this.userManagedIdentityClientId;
    }

    public SiteContainerProperties withUserManagedIdentityClientId(String userManagedIdentityClientId) {
        this.userManagedIdentityClientId = userManagedIdentityClientId;
        return this;
    }

    public OffsetDateTime createdTime() {
        return this.createdTime;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public List<VolumeMount> volumeMounts() {
        return this.volumeMounts;
    }

    public SiteContainerProperties withVolumeMounts(List<VolumeMount> volumeMounts) {
        this.volumeMounts = volumeMounts;
        return this;
    }

    public List<EnvironmentVariable> environmentVariables() {
        return this.environmentVariables;
    }

    public SiteContainerProperties withEnvironmentVariables(List<EnvironmentVariable> environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    public void validate() {
        if (this.image() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property image in model SiteContainerProperties"));
        }
        if (this.volumeMounts() != null) {
            this.volumeMounts().forEach(e -> e.validate());
        }
        if (this.environmentVariables() != null) {
            this.environmentVariables().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("image", this.image);
        jsonWriter.writeBooleanField("isMain", this.isMain);
        jsonWriter.writeStringField("targetPort", this.targetPort);
        jsonWriter.writeStringField("startUpCommand", this.startUpCommand);
        jsonWriter.writeStringField("authType", this.authType == null ? null : this.authType.toString());
        jsonWriter.writeStringField("userName", this.username);
        jsonWriter.writeStringField("passwordSecret", this.passwordSecret);
        jsonWriter.writeStringField("userManagedIdentityClientId", this.userManagedIdentityClientId);
        jsonWriter.writeArrayField("volumeMounts", this.volumeMounts, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("environmentVariables", this.environmentVariables, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SiteContainerProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SiteContainerProperties)jsonReader.readObject(reader -> {
            SiteContainerProperties deserializedSiteContainerProperties = new SiteContainerProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("image".equals(fieldName)) {
                    deserializedSiteContainerProperties.image = reader.getString();
                    continue;
                }
                if ("isMain".equals(fieldName)) {
                    deserializedSiteContainerProperties.isMain = reader.getBoolean();
                    continue;
                }
                if ("targetPort".equals(fieldName)) {
                    deserializedSiteContainerProperties.targetPort = reader.getString();
                    continue;
                }
                if ("startUpCommand".equals(fieldName)) {
                    deserializedSiteContainerProperties.startUpCommand = reader.getString();
                    continue;
                }
                if ("authType".equals(fieldName)) {
                    deserializedSiteContainerProperties.authType = AuthType.fromString(reader.getString());
                    continue;
                }
                if ("userName".equals(fieldName)) {
                    deserializedSiteContainerProperties.username = reader.getString();
                    continue;
                }
                if ("passwordSecret".equals(fieldName)) {
                    deserializedSiteContainerProperties.passwordSecret = reader.getString();
                    continue;
                }
                if ("userManagedIdentityClientId".equals(fieldName)) {
                    deserializedSiteContainerProperties.userManagedIdentityClientId = reader.getString();
                    continue;
                }
                if ("createdTime".equals(fieldName)) {
                    deserializedSiteContainerProperties.createdTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedSiteContainerProperties.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("volumeMounts".equals(fieldName)) {
                    List volumeMounts;
                    deserializedSiteContainerProperties.volumeMounts = volumeMounts = reader.readArray(reader1 -> VolumeMount.fromJson(reader1));
                    continue;
                }
                if ("environmentVariables".equals(fieldName)) {
                    List environmentVariables;
                    deserializedSiteContainerProperties.environmentVariables = environmentVariables = reader.readArray(reader1 -> EnvironmentVariable.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSiteContainerProperties;
        });
    }
}

