/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ContainerAppSecret;
import java.io.IOException;
import java.util.List;

public final class SecretsCollectionInner
implements JsonSerializable<SecretsCollectionInner> {
    private List<ContainerAppSecret> value;
    private static final ClientLogger LOGGER = new ClientLogger(SecretsCollectionInner.class);

    public List<ContainerAppSecret> value() {
        return this.value;
    }

    public SecretsCollectionInner withValue(List<ContainerAppSecret> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model SecretsCollectionInner"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SecretsCollectionInner fromJson(JsonReader jsonReader) throws IOException {
        return (SecretsCollectionInner)jsonReader.readObject(reader -> {
            SecretsCollectionInner deserializedSecretsCollectionInner = new SecretsCollectionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedSecretsCollectionInner.value = value = reader.readArray(reader1 -> ContainerAppSecret.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecretsCollectionInner;
        });
    }
}

