/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.RecommendationProperties;
import com.azure.resourcemanager.appservice.models.Channels;
import com.azure.resourcemanager.appservice.models.NotificationLevel;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.ResourceScopeType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.UUID;

public final class RecommendationInner
extends ProxyOnlyResource {
    private RecommendationProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private RecommendationProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public RecommendationInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().creationTime();
    }

    public RecommendationInner withCreationTime(OffsetDateTime creationTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withCreationTime(creationTime);
        return this;
    }

    public UUID recommendationId() {
        return this.innerProperties() == null ? null : this.innerProperties().recommendationId();
    }

    public RecommendationInner withRecommendationId(UUID recommendationId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withRecommendationId(recommendationId);
        return this;
    }

    public String resourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceId();
    }

    public RecommendationInner withResourceId(String resourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withResourceId(resourceId);
        return this;
    }

    public ResourceScopeType resourceScope() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceScope();
    }

    public RecommendationInner withResourceScope(ResourceScopeType resourceScope) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withResourceScope(resourceScope);
        return this;
    }

    public String ruleName() {
        return this.innerProperties() == null ? null : this.innerProperties().ruleName();
    }

    public RecommendationInner withRuleName(String ruleName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withRuleName(ruleName);
        return this;
    }

    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    public RecommendationInner withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    public String message() {
        return this.innerProperties() == null ? null : this.innerProperties().message();
    }

    public RecommendationInner withMessage(String message) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withMessage(message);
        return this;
    }

    public NotificationLevel level() {
        return this.innerProperties() == null ? null : this.innerProperties().level();
    }

    public RecommendationInner withLevel(NotificationLevel level) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withLevel(level);
        return this;
    }

    public Channels channels() {
        return this.innerProperties() == null ? null : this.innerProperties().channels();
    }

    public RecommendationInner withChannels(Channels channels) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withChannels(channels);
        return this;
    }

    public List<String> categoryTags() {
        return this.innerProperties() == null ? null : this.innerProperties().categoryTags();
    }

    public String actionName() {
        return this.innerProperties() == null ? null : this.innerProperties().actionName();
    }

    public RecommendationInner withActionName(String actionName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withActionName(actionName);
        return this;
    }

    public Integer enabled() {
        return this.innerProperties() == null ? null : this.innerProperties().enabled();
    }

    public RecommendationInner withEnabled(Integer enabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withEnabled(enabled);
        return this;
    }

    public List<String> states() {
        return this.innerProperties() == null ? null : this.innerProperties().states();
    }

    public RecommendationInner withStates(List<String> states) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withStates(states);
        return this;
    }

    public OffsetDateTime startTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startTime();
    }

    public RecommendationInner withStartTime(OffsetDateTime startTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withStartTime(startTime);
        return this;
    }

    public OffsetDateTime endTime() {
        return this.innerProperties() == null ? null : this.innerProperties().endTime();
    }

    public RecommendationInner withEndTime(OffsetDateTime endTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withEndTime(endTime);
        return this;
    }

    public OffsetDateTime nextNotificationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().nextNotificationTime();
    }

    public RecommendationInner withNextNotificationTime(OffsetDateTime nextNotificationTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withNextNotificationTime(nextNotificationTime);
        return this;
    }

    public OffsetDateTime notificationExpirationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().notificationExpirationTime();
    }

    public RecommendationInner withNotificationExpirationTime(OffsetDateTime notificationExpirationTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withNotificationExpirationTime(notificationExpirationTime);
        return this;
    }

    public OffsetDateTime notifiedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().notifiedTime();
    }

    public RecommendationInner withNotifiedTime(OffsetDateTime notifiedTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withNotifiedTime(notifiedTime);
        return this;
    }

    public Double score() {
        return this.innerProperties() == null ? null : this.innerProperties().score();
    }

    public RecommendationInner withScore(Double score) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withScore(score);
        return this;
    }

    public Boolean isDynamic() {
        return this.innerProperties() == null ? null : this.innerProperties().isDynamic();
    }

    public RecommendationInner withIsDynamic(Boolean isDynamic) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withIsDynamic(isDynamic);
        return this;
    }

    public String extensionName() {
        return this.innerProperties() == null ? null : this.innerProperties().extensionName();
    }

    public RecommendationInner withExtensionName(String extensionName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withExtensionName(extensionName);
        return this;
    }

    public String bladeName() {
        return this.innerProperties() == null ? null : this.innerProperties().bladeName();
    }

    public RecommendationInner withBladeName(String bladeName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withBladeName(bladeName);
        return this;
    }

    public String forwardLink() {
        return this.innerProperties() == null ? null : this.innerProperties().forwardLink();
    }

    public RecommendationInner withForwardLink(String forwardLink) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withForwardLink(forwardLink);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static RecommendationInner fromJson(JsonReader jsonReader) throws IOException {
        return (RecommendationInner)((Object)jsonReader.readObject(reader -> {
            RecommendationInner deserializedRecommendationInner = new RecommendationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedRecommendationInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRecommendationInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRecommendationInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedRecommendationInner.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedRecommendationInner.innerProperties = RecommendationProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRecommendationInner;
        }));
    }
}

