/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class ProcessThreadInfoProperties
implements JsonSerializable<ProcessThreadInfoProperties> {
    private Integer identifier;
    private String href;
    private String process;
    private String startAddress;
    private Integer currentPriority;
    private String priorityLevel;
    private Integer basePriority;
    private OffsetDateTime startTime;
    private String totalProcessorTime;
    private String userProcessorTime;
    private String state;
    private String waitReason;

    public Integer identifier() {
        return this.identifier;
    }

    public String href() {
        return this.href;
    }

    public ProcessThreadInfoProperties withHref(String href) {
        this.href = href;
        return this;
    }

    public String process() {
        return this.process;
    }

    public ProcessThreadInfoProperties withProcess(String process) {
        this.process = process;
        return this;
    }

    public String startAddress() {
        return this.startAddress;
    }

    public ProcessThreadInfoProperties withStartAddress(String startAddress) {
        this.startAddress = startAddress;
        return this;
    }

    public Integer currentPriority() {
        return this.currentPriority;
    }

    public ProcessThreadInfoProperties withCurrentPriority(Integer currentPriority) {
        this.currentPriority = currentPriority;
        return this;
    }

    public String priorityLevel() {
        return this.priorityLevel;
    }

    public ProcessThreadInfoProperties withPriorityLevel(String priorityLevel) {
        this.priorityLevel = priorityLevel;
        return this;
    }

    public Integer basePriority() {
        return this.basePriority;
    }

    public ProcessThreadInfoProperties withBasePriority(Integer basePriority) {
        this.basePriority = basePriority;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public ProcessThreadInfoProperties withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public String totalProcessorTime() {
        return this.totalProcessorTime;
    }

    public ProcessThreadInfoProperties withTotalProcessorTime(String totalProcessorTime) {
        this.totalProcessorTime = totalProcessorTime;
        return this;
    }

    public String userProcessorTime() {
        return this.userProcessorTime;
    }

    public ProcessThreadInfoProperties withUserProcessorTime(String userProcessorTime) {
        this.userProcessorTime = userProcessorTime;
        return this;
    }

    public String state() {
        return this.state;
    }

    public ProcessThreadInfoProperties withState(String state) {
        this.state = state;
        return this;
    }

    public String waitReason() {
        return this.waitReason;
    }

    public ProcessThreadInfoProperties withWaitReason(String waitReason) {
        this.waitReason = waitReason;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("href", this.href);
        jsonWriter.writeStringField("process", this.process);
        jsonWriter.writeStringField("start_address", this.startAddress);
        jsonWriter.writeNumberField("current_priority", (Number)this.currentPriority);
        jsonWriter.writeStringField("priority_level", this.priorityLevel);
        jsonWriter.writeNumberField("base_priority", (Number)this.basePriority);
        jsonWriter.writeStringField("start_time", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("total_processor_time", this.totalProcessorTime);
        jsonWriter.writeStringField("user_processor_time", this.userProcessorTime);
        jsonWriter.writeStringField("state", this.state);
        jsonWriter.writeStringField("wait_reason", this.waitReason);
        return jsonWriter.writeEndObject();
    }

    public static ProcessThreadInfoProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ProcessThreadInfoProperties)jsonReader.readObject(reader -> {
            ProcessThreadInfoProperties deserializedProcessThreadInfoProperties = new ProcessThreadInfoProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("identifier".equals(fieldName)) {
                    deserializedProcessThreadInfoProperties.identifier = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("href".equals(fieldName)) {
                    deserializedProcessThreadInfoProperties.href = reader.getString();
                    continue;
                }
                if ("process".equals(fieldName)) {
                    deserializedProcessThreadInfoProperties.process = reader.getString();
                    continue;
                }
                if ("start_address".equals(fieldName)) {
                    deserializedProcessThreadInfoProperties.startAddress = reader.getString();
                    continue;
                }
                if ("current_priority".equals(fieldName)) {
                    deserializedProcessThreadInfoProperties.currentPriority = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("priority_level".equals(fieldName)) {
                    deserializedProcessThreadInfoProperties.priorityLevel = reader.getString();
                    continue;
                }
                if ("base_priority".equals(fieldName)) {
                    deserializedProcessThreadInfoProperties.basePriority = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("start_time".equals(fieldName)) {
                    deserializedProcessThreadInfoProperties.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("total_processor_time".equals(fieldName)) {
                    deserializedProcessThreadInfoProperties.totalProcessorTime = reader.getString();
                    continue;
                }
                if ("user_processor_time".equals(fieldName)) {
                    deserializedProcessThreadInfoProperties.userProcessorTime = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedProcessThreadInfoProperties.state = reader.getString();
                    continue;
                }
                if ("wait_reason".equals(fieldName)) {
                    deserializedProcessThreadInfoProperties.waitReason = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProcessThreadInfoProperties;
        });
    }
}

