/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.MySqlMigrationType;
import java.io.IOException;

public final class MigrateMySqlRequestProperties
implements JsonSerializable<MigrateMySqlRequestProperties> {
    private String connectionString;
    private MySqlMigrationType migrationType;
    private static final ClientLogger LOGGER = new ClientLogger(MigrateMySqlRequestProperties.class);

    public String connectionString() {
        return this.connectionString;
    }

    public MigrateMySqlRequestProperties withConnectionString(String connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public MySqlMigrationType migrationType() {
        return this.migrationType;
    }

    public MigrateMySqlRequestProperties withMigrationType(MySqlMigrationType migrationType) {
        this.migrationType = migrationType;
        return this;
    }

    public void validate() {
        if (this.connectionString() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property connectionString in model MigrateMySqlRequestProperties"));
        }
        if (this.migrationType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property migrationType in model MigrateMySqlRequestProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("connectionString", this.connectionString);
        jsonWriter.writeStringField("migrationType", this.migrationType == null ? null : this.migrationType.toString());
        return jsonWriter.writeEndObject();
    }

    public static MigrateMySqlRequestProperties fromJson(JsonReader jsonReader) throws IOException {
        return (MigrateMySqlRequestProperties)jsonReader.readObject(reader -> {
            MigrateMySqlRequestProperties deserializedMigrateMySqlRequestProperties = new MigrateMySqlRequestProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectionString".equals(fieldName)) {
                    deserializedMigrateMySqlRequestProperties.connectionString = reader.getString();
                    continue;
                }
                if ("migrationType".equals(fieldName)) {
                    deserializedMigrateMySqlRequestProperties.migrationType = MySqlMigrationType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrateMySqlRequestProperties;
        });
    }
}

