/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class HybridConnectionProperties
implements JsonSerializable<HybridConnectionProperties> {
    private String serviceBusNamespace;
    private String relayName;
    private String relayArmUri;
    private String hostname;
    private Integer port;
    private String sendKeyName;
    private String sendKeyValue;
    private String serviceBusSuffix;

    public String serviceBusNamespace() {
        return this.serviceBusNamespace;
    }

    public HybridConnectionProperties withServiceBusNamespace(String serviceBusNamespace) {
        this.serviceBusNamespace = serviceBusNamespace;
        return this;
    }

    public String relayName() {
        return this.relayName;
    }

    public HybridConnectionProperties withRelayName(String relayName) {
        this.relayName = relayName;
        return this;
    }

    public String relayArmUri() {
        return this.relayArmUri;
    }

    public HybridConnectionProperties withRelayArmUri(String relayArmUri) {
        this.relayArmUri = relayArmUri;
        return this;
    }

    public String hostname() {
        return this.hostname;
    }

    public HybridConnectionProperties withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public Integer port() {
        return this.port;
    }

    public HybridConnectionProperties withPort(Integer port) {
        this.port = port;
        return this;
    }

    public String sendKeyName() {
        return this.sendKeyName;
    }

    public HybridConnectionProperties withSendKeyName(String sendKeyName) {
        this.sendKeyName = sendKeyName;
        return this;
    }

    public String sendKeyValue() {
        return this.sendKeyValue;
    }

    public HybridConnectionProperties withSendKeyValue(String sendKeyValue) {
        this.sendKeyValue = sendKeyValue;
        return this;
    }

    public String serviceBusSuffix() {
        return this.serviceBusSuffix;
    }

    public HybridConnectionProperties withServiceBusSuffix(String serviceBusSuffix) {
        this.serviceBusSuffix = serviceBusSuffix;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serviceBusNamespace", this.serviceBusNamespace);
        jsonWriter.writeStringField("relayName", this.relayName);
        jsonWriter.writeStringField("relayArmUri", this.relayArmUri);
        jsonWriter.writeStringField("hostname", this.hostname);
        jsonWriter.writeNumberField("port", (Number)this.port);
        jsonWriter.writeStringField("sendKeyName", this.sendKeyName);
        jsonWriter.writeStringField("sendKeyValue", this.sendKeyValue);
        jsonWriter.writeStringField("serviceBusSuffix", this.serviceBusSuffix);
        return jsonWriter.writeEndObject();
    }

    public static HybridConnectionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (HybridConnectionProperties)jsonReader.readObject(reader -> {
            HybridConnectionProperties deserializedHybridConnectionProperties = new HybridConnectionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("serviceBusNamespace".equals(fieldName)) {
                    deserializedHybridConnectionProperties.serviceBusNamespace = reader.getString();
                    continue;
                }
                if ("relayName".equals(fieldName)) {
                    deserializedHybridConnectionProperties.relayName = reader.getString();
                    continue;
                }
                if ("relayArmUri".equals(fieldName)) {
                    deserializedHybridConnectionProperties.relayArmUri = reader.getString();
                    continue;
                }
                if ("hostname".equals(fieldName)) {
                    deserializedHybridConnectionProperties.hostname = reader.getString();
                    continue;
                }
                if ("port".equals(fieldName)) {
                    deserializedHybridConnectionProperties.port = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("sendKeyName".equals(fieldName)) {
                    deserializedHybridConnectionProperties.sendKeyName = reader.getString();
                    continue;
                }
                if ("sendKeyValue".equals(fieldName)) {
                    deserializedHybridConnectionProperties.sendKeyValue = reader.getString();
                    continue;
                }
                if ("serviceBusSuffix".equals(fieldName)) {
                    deserializedHybridConnectionProperties.serviceBusSuffix = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHybridConnectionProperties;
        });
    }
}

