/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.AppServiceEnvironmentInner;
import com.azure.resourcemanager.appservice.fluent.models.GeoRegionInner;
import com.azure.resourcemanager.appservice.models.HostingEnvironmentDeploymentInfo;
import java.io.IOException;
import java.util.List;

public final class DeploymentLocationsInner
implements JsonSerializable<DeploymentLocationsInner> {
    private List<GeoRegionInner> locations;
    private List<AppServiceEnvironmentInner> hostingEnvironments;
    private List<HostingEnvironmentDeploymentInfo> hostingEnvironmentDeploymentInfos;

    public List<GeoRegionInner> locations() {
        return this.locations;
    }

    public DeploymentLocationsInner withLocations(List<GeoRegionInner> locations) {
        this.locations = locations;
        return this;
    }

    public List<AppServiceEnvironmentInner> hostingEnvironments() {
        return this.hostingEnvironments;
    }

    public DeploymentLocationsInner withHostingEnvironments(List<AppServiceEnvironmentInner> hostingEnvironments) {
        this.hostingEnvironments = hostingEnvironments;
        return this;
    }

    public List<HostingEnvironmentDeploymentInfo> hostingEnvironmentDeploymentInfos() {
        return this.hostingEnvironmentDeploymentInfos;
    }

    public DeploymentLocationsInner withHostingEnvironmentDeploymentInfos(List<HostingEnvironmentDeploymentInfo> hostingEnvironmentDeploymentInfos) {
        this.hostingEnvironmentDeploymentInfos = hostingEnvironmentDeploymentInfos;
        return this;
    }

    public void validate() {
        if (this.locations() != null) {
            this.locations().forEach(e -> e.validate());
        }
        if (this.hostingEnvironments() != null) {
            this.hostingEnvironments().forEach(e -> e.validate());
        }
        if (this.hostingEnvironmentDeploymentInfos() != null) {
            this.hostingEnvironmentDeploymentInfos().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("locations", this.locations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("hostingEnvironments", this.hostingEnvironments, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("hostingEnvironmentDeploymentInfos", this.hostingEnvironmentDeploymentInfos, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DeploymentLocationsInner fromJson(JsonReader jsonReader) throws IOException {
        return (DeploymentLocationsInner)jsonReader.readObject(reader -> {
            DeploymentLocationsInner deserializedDeploymentLocationsInner = new DeploymentLocationsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("locations".equals(fieldName)) {
                    List locations;
                    deserializedDeploymentLocationsInner.locations = locations = reader.readArray(reader1 -> GeoRegionInner.fromJson(reader1));
                    continue;
                }
                if ("hostingEnvironments".equals(fieldName)) {
                    List hostingEnvironments;
                    deserializedDeploymentLocationsInner.hostingEnvironments = hostingEnvironments = reader.readArray(reader1 -> AppServiceEnvironmentInner.fromJson(reader1));
                    continue;
                }
                if ("hostingEnvironmentDeploymentInfos".equals(fieldName)) {
                    List hostingEnvironmentDeploymentInfos;
                    deserializedDeploymentLocationsInner.hostingEnvironmentDeploymentInfos = hostingEnvironmentDeploymentInfos = reader.readArray(reader1 -> HostingEnvironmentDeploymentInfo.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeploymentLocationsInner;
        });
    }
}

