// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/** State indicating whether the app has exceeded its quota usage. Read-only. */
public enum UsageState {
    /** Enum value Normal. */
    NORMAL("Normal"),

    /** Enum value Exceeded. */
    EXCEEDED("Exceeded");

    /** The actual serialized value for a UsageState instance. */
    private final String value;

    UsageState(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a UsageState instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed UsageState object, or null if unable to parse.
     */
    @JsonCreator
    public static UsageState fromString(String value) {
        if (value == null) {
            return null;
        }
        UsageState[] items = UsageState.values();
        for (UsageState item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /** {@inheritDoc} */
    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
