// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/** The action to take when an unauthenticated client attempts to access the app. */
public enum UnauthenticatedClientActionV2 {
    /** Enum value RedirectToLoginPage. */
    REDIRECT_TO_LOGIN_PAGE("RedirectToLoginPage"),

    /** Enum value AllowAnonymous. */
    ALLOW_ANONYMOUS("AllowAnonymous"),

    /** Enum value Return401. */
    RETURN401("Return401"),

    /** Enum value Return403. */
    RETURN403("Return403");

    /** The actual serialized value for a UnauthenticatedClientActionV2 instance. */
    private final String value;

    UnauthenticatedClientActionV2(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a UnauthenticatedClientActionV2 instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed UnauthenticatedClientActionV2 object, or null if unable to parse.
     */
    @JsonCreator
    public static UnauthenticatedClientActionV2 fromString(String value) {
        if (value == null) {
            return null;
        }
        UnauthenticatedClientActionV2[] items = UnauthenticatedClientActionV2.values();
        for (UnauthenticatedClientActionV2 item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /** {@inheritDoc} */
    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
