// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** Linux Java Container settings. */
@Immutable
public final class LinuxJavaContainerSettings {
    /*
     * Java 11 version (runtime only).
     */
    @JsonProperty(value = "java11Runtime", access = JsonProperty.Access.WRITE_ONLY)
    private String java11Runtime;

    /*
     * Java 8 version (runtime only).
     */
    @JsonProperty(value = "java8Runtime", access = JsonProperty.Access.WRITE_ONLY)
    private String java8Runtime;

    /*
     * <code>true</code> if the stack is in preview; otherwise, <code>false</code>.
     */
    @JsonProperty(value = "isPreview", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean isPreview;

    /*
     * <code>true</code> if the stack is deprecated; otherwise, <code>false</code>.
     */
    @JsonProperty(value = "isDeprecated", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean isDeprecated;

    /*
     * <code>true</code> if the stack should be hidden; otherwise, <code>false</code>.
     */
    @JsonProperty(value = "isHidden", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean isHidden;

    /*
     * End-of-life date for the minor version.
     */
    @JsonProperty(value = "endOfLifeDate", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime endOfLifeDate;

    /*
     * <code>true</code> if the stack version is auto-updated; otherwise, <code>false</code>.
     */
    @JsonProperty(value = "isAutoUpdate", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean isAutoUpdate;

    /*
     * <code>true</code> if the minor version is early-access; otherwise, <code>false</code>.
     */
    @JsonProperty(value = "isEarlyAccess", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean isEarlyAccess;

    /** Creates an instance of LinuxJavaContainerSettings class. */
    public LinuxJavaContainerSettings() {
    }

    /**
     * Get the java11Runtime property: Java 11 version (runtime only).
     *
     * @return the java11Runtime value.
     */
    public String java11Runtime() {
        return this.java11Runtime;
    }

    /**
     * Get the java8Runtime property: Java 8 version (runtime only).
     *
     * @return the java8Runtime value.
     */
    public String java8Runtime() {
        return this.java8Runtime;
    }

    /**
     * Get the isPreview property: &lt;code&gt;true&lt;/code&gt; if the stack is in preview; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     *
     * @return the isPreview value.
     */
    public Boolean isPreview() {
        return this.isPreview;
    }

    /**
     * Get the isDeprecated property: &lt;code&gt;true&lt;/code&gt; if the stack is deprecated; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     *
     * @return the isDeprecated value.
     */
    public Boolean isDeprecated() {
        return this.isDeprecated;
    }

    /**
     * Get the isHidden property: &lt;code&gt;true&lt;/code&gt; if the stack should be hidden; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     *
     * @return the isHidden value.
     */
    public Boolean isHidden() {
        return this.isHidden;
    }

    /**
     * Get the endOfLifeDate property: End-of-life date for the minor version.
     *
     * @return the endOfLifeDate value.
     */
    public OffsetDateTime endOfLifeDate() {
        return this.endOfLifeDate;
    }

    /**
     * Get the isAutoUpdate property: &lt;code&gt;true&lt;/code&gt; if the stack version is auto-updated; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     *
     * @return the isAutoUpdate value.
     */
    public Boolean isAutoUpdate() {
        return this.isAutoUpdate;
    }

    /**
     * Get the isEarlyAccess property: &lt;code&gt;true&lt;/code&gt; if the minor version is early-access; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     *
     * @return the isEarlyAccess value.
     */
    public Boolean isEarlyAccess() {
        return this.isEarlyAccess;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
