// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The configuration settings of the Facebook provider. */
@Fluent
public final class Facebook {
    /*
     * <code>false</code> if the Facebook provider should not be enabled despite the set registration; otherwise,
     * <code>true</code>.
     */
    @JsonProperty(value = "enabled")
    private Boolean enabled;

    /*
     * The configuration settings of the app registration for the Facebook provider.
     */
    @JsonProperty(value = "registration")
    private AppRegistration registration;

    /*
     * The version of the Facebook api to be used while logging in.
     */
    @JsonProperty(value = "graphApiVersion")
    private String graphApiVersion;

    /*
     * The configuration settings of the login flow.
     */
    @JsonProperty(value = "login")
    private LoginScopes login;

    /** Creates an instance of Facebook class. */
    public Facebook() {
    }

    /**
     * Get the enabled property: &lt;code&gt;false&lt;/code&gt; if the Facebook provider should not be enabled despite
     * the set registration; otherwise, &lt;code&gt;true&lt;/code&gt;.
     *
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: &lt;code&gt;false&lt;/code&gt; if the Facebook provider should not be enabled despite
     * the set registration; otherwise, &lt;code&gt;true&lt;/code&gt;.
     *
     * @param enabled the enabled value to set.
     * @return the Facebook object itself.
     */
    public Facebook withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the registration property: The configuration settings of the app registration for the Facebook provider.
     *
     * @return the registration value.
     */
    public AppRegistration registration() {
        return this.registration;
    }

    /**
     * Set the registration property: The configuration settings of the app registration for the Facebook provider.
     *
     * @param registration the registration value to set.
     * @return the Facebook object itself.
     */
    public Facebook withRegistration(AppRegistration registration) {
        this.registration = registration;
        return this;
    }

    /**
     * Get the graphApiVersion property: The version of the Facebook api to be used while logging in.
     *
     * @return the graphApiVersion value.
     */
    public String graphApiVersion() {
        return this.graphApiVersion;
    }

    /**
     * Set the graphApiVersion property: The version of the Facebook api to be used while logging in.
     *
     * @param graphApiVersion the graphApiVersion value to set.
     * @return the Facebook object itself.
     */
    public Facebook withGraphApiVersion(String graphApiVersion) {
        this.graphApiVersion = graphApiVersion;
        return this;
    }

    /**
     * Get the login property: The configuration settings of the login flow.
     *
     * @return the login value.
     */
    public LoginScopes login() {
        return this.login;
    }

    /**
     * Set the login property: The configuration settings of the login flow.
     *
     * @param login the login value to set.
     * @return the Facebook object itself.
     */
    public Facebook withLogin(LoginScopes login) {
        this.login = login;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (registration() != null) {
            registration().validate();
        }
        if (login() != null) {
            login().validate();
        }
    }
}
