// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The configuration settings of the custom Open ID Connect provider. */
@Fluent
public final class CustomOpenIdConnectProvider {
    /*
     * <code>false</code> if the custom Open ID provider provider should not be enabled; otherwise, <code>true</code>.
     */
    @JsonProperty(value = "enabled")
    private Boolean enabled;

    /*
     * The configuration settings of the app registration for the custom Open ID Connect provider.
     */
    @JsonProperty(value = "registration")
    private OpenIdConnectRegistration registration;

    /*
     * The configuration settings of the login flow of the custom Open ID Connect provider.
     */
    @JsonProperty(value = "login")
    private OpenIdConnectLogin login;

    /** Creates an instance of CustomOpenIdConnectProvider class. */
    public CustomOpenIdConnectProvider() {
    }

    /**
     * Get the enabled property: &lt;code&gt;false&lt;/code&gt; if the custom Open ID provider provider should not be
     * enabled; otherwise, &lt;code&gt;true&lt;/code&gt;.
     *
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: &lt;code&gt;false&lt;/code&gt; if the custom Open ID provider provider should not be
     * enabled; otherwise, &lt;code&gt;true&lt;/code&gt;.
     *
     * @param enabled the enabled value to set.
     * @return the CustomOpenIdConnectProvider object itself.
     */
    public CustomOpenIdConnectProvider withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the registration property: The configuration settings of the app registration for the custom Open ID Connect
     * provider.
     *
     * @return the registration value.
     */
    public OpenIdConnectRegistration registration() {
        return this.registration;
    }

    /**
     * Set the registration property: The configuration settings of the app registration for the custom Open ID Connect
     * provider.
     *
     * @param registration the registration value to set.
     * @return the CustomOpenIdConnectProvider object itself.
     */
    public CustomOpenIdConnectProvider withRegistration(OpenIdConnectRegistration registration) {
        this.registration = registration;
        return this;
    }

    /**
     * Get the login property: The configuration settings of the login flow of the custom Open ID Connect provider.
     *
     * @return the login value.
     */
    public OpenIdConnectLogin login() {
        return this.login;
    }

    /**
     * Set the login property: The configuration settings of the login flow of the custom Open ID Connect provider.
     *
     * @param login the login value to set.
     * @return the CustomOpenIdConnectProvider object itself.
     */
    public CustomOpenIdConnectProvider withLogin(OpenIdConnectLogin login) {
        this.login = login;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (registration() != null) {
            registration().validate();
        }
        if (login() != null) {
            login().validate();
        }
    }
}
