// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Properties available for a Microsoft.Web resource provider operation. */
@Fluent
public final class CsmOperationDescriptionProperties {
    /*
     * Resource metrics service provided by Microsoft.Insights resource provider.
     */
    @JsonProperty(value = "serviceSpecification")
    private ServiceSpecification serviceSpecification;

    /** Creates an instance of CsmOperationDescriptionProperties class. */
    public CsmOperationDescriptionProperties() {
    }

    /**
     * Get the serviceSpecification property: Resource metrics service provided by Microsoft.Insights resource provider.
     *
     * @return the serviceSpecification value.
     */
    public ServiceSpecification serviceSpecification() {
        return this.serviceSpecification;
    }

    /**
     * Set the serviceSpecification property: Resource metrics service provided by Microsoft.Insights resource provider.
     *
     * @param serviceSpecification the serviceSpecification value to set.
     * @return the CsmOperationDescriptionProperties object itself.
     */
    public CsmOperationDescriptionProperties withServiceSpecification(ServiceSpecification serviceSpecification) {
        this.serviceSpecification = serviceSpecification;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (serviceSpecification() != null) {
            serviceSpecification().validate();
        }
    }
}
