// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Static site basic auth properties ARM resource. */
@Fluent
public final class StaticSiteBasicAuthPropertiesArmResourceInner extends ProxyOnlyResource {
    /*
     * StaticSiteBasicAuthPropertiesARMResource resource specific properties
     */
    @JsonProperty(value = "properties")
    private StaticSiteBasicAuthPropertiesArmResourceProperties innerProperties;

    /** Creates an instance of StaticSiteBasicAuthPropertiesArmResourceInner class. */
    public StaticSiteBasicAuthPropertiesArmResourceInner() {
    }

    /**
     * Get the innerProperties property: StaticSiteBasicAuthPropertiesARMResource resource specific properties.
     *
     * @return the innerProperties value.
     */
    private StaticSiteBasicAuthPropertiesArmResourceProperties innerProperties() {
        return this.innerProperties;
    }

    /** {@inheritDoc} */
    @Override
    public StaticSiteBasicAuthPropertiesArmResourceInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the password property: The password for basic auth.
     *
     * @return the password value.
     */
    public String password() {
        return this.innerProperties() == null ? null : this.innerProperties().password();
    }

    /**
     * Set the password property: The password for basic auth.
     *
     * @param password the password value to set.
     * @return the StaticSiteBasicAuthPropertiesArmResourceInner object itself.
     */
    public StaticSiteBasicAuthPropertiesArmResourceInner withPassword(String password) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSiteBasicAuthPropertiesArmResourceProperties();
        }
        this.innerProperties().withPassword(password);
        return this;
    }

    /**
     * Get the secretUrl property: Url to the secret in Key Vault.
     *
     * @return the secretUrl value.
     */
    public String secretUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().secretUrl();
    }

    /**
     * Set the secretUrl property: Url to the secret in Key Vault.
     *
     * @param secretUrl the secretUrl value to set.
     * @return the StaticSiteBasicAuthPropertiesArmResourceInner object itself.
     */
    public StaticSiteBasicAuthPropertiesArmResourceInner withSecretUrl(String secretUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSiteBasicAuthPropertiesArmResourceProperties();
        }
        this.innerProperties().withSecretUrl(secretUrl);
        return this;
    }

    /**
     * Get the applicableEnvironmentsMode property: State indicating if basic auth is enabled and for what environments
     * it is active.
     *
     * @return the applicableEnvironmentsMode value.
     */
    public String applicableEnvironmentsMode() {
        return this.innerProperties() == null ? null : this.innerProperties().applicableEnvironmentsMode();
    }

    /**
     * Set the applicableEnvironmentsMode property: State indicating if basic auth is enabled and for what environments
     * it is active.
     *
     * @param applicableEnvironmentsMode the applicableEnvironmentsMode value to set.
     * @return the StaticSiteBasicAuthPropertiesArmResourceInner object itself.
     */
    public StaticSiteBasicAuthPropertiesArmResourceInner withApplicableEnvironmentsMode(
        String applicableEnvironmentsMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSiteBasicAuthPropertiesArmResourceProperties();
        }
        this.innerProperties().withApplicableEnvironmentsMode(applicableEnvironmentsMode);
        return this;
    }

    /**
     * Get the environments property: The list of enabled environments for Basic Auth if ApplicableEnvironmentsMode is
     * set to SpecifiedEnvironments.
     *
     * @return the environments value.
     */
    public List<String> environments() {
        return this.innerProperties() == null ? null : this.innerProperties().environments();
    }

    /**
     * Set the environments property: The list of enabled environments for Basic Auth if ApplicableEnvironmentsMode is
     * set to SpecifiedEnvironments.
     *
     * @param environments the environments value to set.
     * @return the StaticSiteBasicAuthPropertiesArmResourceInner object itself.
     */
    public StaticSiteBasicAuthPropertiesArmResourceInner withEnvironments(List<String> environments) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSiteBasicAuthPropertiesArmResourceProperties();
        }
        this.innerProperties().withEnvironments(environments);
        return this;
    }

    /**
     * Get the secretState property: State indicating if basic auth has a secret and what type it is.
     *
     * @return the secretState value.
     */
    public String secretState() {
        return this.innerProperties() == null ? null : this.innerProperties().secretState();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
