// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.fasterxml.jackson.annotation.JsonProperty;

/** A snapshot of an app. */
@Fluent
public final class SnapshotInner extends ProxyOnlyResource {
    /*
     * Snapshot resource specific properties
     */
    @JsonProperty(value = "properties")
    private SnapshotProperties innerProperties;

    /** Creates an instance of SnapshotInner class. */
    public SnapshotInner() {
    }

    /**
     * Get the innerProperties property: Snapshot resource specific properties.
     *
     * @return the innerProperties value.
     */
    private SnapshotProperties innerProperties() {
        return this.innerProperties;
    }

    /** {@inheritDoc} */
    @Override
    public SnapshotInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the time property: The time the snapshot was taken.
     *
     * @return the time value.
     */
    public String time() {
        return this.innerProperties() == null ? null : this.innerProperties().time();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
