/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.resourcemanager.appservice.models.AppServicePlan;
import com.azure.resourcemanager.appservice.models.DeploymentSlots;
import com.azure.resourcemanager.appservice.models.PricingTier;
import com.azure.resourcemanager.appservice.models.RuntimeStack;
import com.azure.resourcemanager.appservice.models.SupportsOneDeploy;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.azure.resourcemanager.appservice.models.WebAppBasic;
import com.azure.resourcemanager.appservice.models.WebAppRuntimeStack;
import com.azure.resourcemanager.resources.fluentcore.arm.models.GroupableResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.collection.SupportsListingPrivateEndpointConnection;
import com.azure.resourcemanager.resources.fluentcore.collection.SupportsListingPrivateLinkResource;
import com.azure.resourcemanager.resources.fluentcore.collection.SupportsUpdatingPrivateEndpointConnection;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import com.azure.resourcemanager.resources.models.ResourceGroup;
import java.io.File;
import java.io.InputStream;
import reactor.core.publisher.Mono;

public interface WebApp
extends WebAppBasic,
SupportsOneDeploy,
WebAppBase,
Updatable<Update>,
SupportsListingPrivateLinkResource,
SupportsListingPrivateEndpointConnection,
SupportsUpdatingPrivateEndpointConnection {
    public DeploymentSlots deploymentSlots();

    public void warDeploy(File var1);

    public Mono<Void> warDeployAsync(File var1);

    public void warDeploy(InputStream var1, long var2);

    public Mono<Void> warDeployAsync(InputStream var1, long var2);

    public void warDeploy(File var1, String var2);

    public Mono<Void> warDeployAsync(File var1, String var2);

    public void warDeploy(InputStream var1, long var2, String var4);

    public Mono<Void> warDeployAsync(InputStream var1, long var2, String var4);

    public static interface Update
    extends Appliable<WebApp>,
    UpdateStages.WithAppServicePlan,
    UpdateStages.WithContainerImage,
    UpdateStages.WithWindowsRuntimeStack,
    UpdateStages.WithLinuxAppImage,
    WebAppBase.Update<WebApp> {
    }

    public static interface UpdateStages {

        public static interface WithWindowsRuntimeStack {
            public Update withRuntimeStack(WebAppRuntimeStack var1);
        }

        public static interface WithStartUpCommand
        extends Update {
            public Update withStartUpCommand(String var1);
        }

        public static interface WithCredentials {
            public WithStartUpCommand withCredentials(String var1, String var2);
        }

        public static interface WithLinuxAppImage {
            public Update withBuiltInImage(RuntimeStack var1);
        }

        public static interface WithContainerImage {
            public WithStartUpCommand withPublicDockerHubImage(String var1);

            public WithCredentials withPrivateDockerHubImage(String var1);

            public WithCredentials withPrivateRegistryImage(String var1, String var2);
        }

        public static interface WithAppServicePlan {
            public Update withNewFreeAppServicePlan();

            public Update withNewSharedAppServicePlan();

            public Update withNewAppServicePlan(PricingTier var1);

            public Update withNewAppServicePlan(String var1, PricingTier var2);

            public Update withNewAppServicePlan(Creatable<AppServicePlan> var1);

            public Update withExistingAppServicePlan(AppServicePlan var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<WebApp>,
        WebAppBase.DefinitionStages.WithCreate<WebApp> {
        }

        public static interface WithWindowsAppFramework
        extends WithContainerImage,
        WithCreate {
            public WithCreate withRuntimeStack(WebAppRuntimeStack var1);
        }

        public static interface WithStartUpCommand
        extends WithCreate {
            public WithCreate withStartUpCommand(String var1);
        }

        public static interface WithCredentials {
            public WithStartUpCommand withCredentials(String var1, String var2);
        }

        public static interface WithLinuxAppFramework
        extends WithContainerImage {
            public WithCreate withBuiltInImage(RuntimeStack var1);
        }

        public static interface WithContainerImage {
            public WithStartUpCommand withPublicDockerHubImage(String var1);

            public WithCredentials withPrivateDockerHubImage(String var1);

            public WithCredentials withPrivateRegistryImage(String var1, String var2);
        }

        public static interface WithNewAppServicePlan {
            public WithWindowsAppFramework withNewFreeAppServicePlan();

            public WithWindowsAppFramework withNewSharedAppServicePlan();

            public WithWindowsAppFramework withNewWindowsPlan(PricingTier var1);

            public WithWindowsAppFramework withNewWindowsPlan(String var1, PricingTier var2);

            public WithWindowsAppFramework withNewWindowsPlan(Creatable<AppServicePlan> var1);

            public WithLinuxAppFramework withNewLinuxPlan(PricingTier var1);

            public WithLinuxAppFramework withNewLinuxPlan(String var1, PricingTier var2);

            public WithLinuxAppFramework withNewLinuxPlan(Creatable<AppServicePlan> var1);
        }

        public static interface ExistingLinuxPlanWithGroup {
            public WithLinuxAppFramework withExistingResourceGroup(String var1);

            public WithLinuxAppFramework withExistingResourceGroup(ResourceGroup var1);

            public WithLinuxAppFramework withNewResourceGroup(String var1);

            public WithLinuxAppFramework withNewResourceGroup();

            public WithLinuxAppFramework withNewResourceGroup(Creatable<ResourceGroup> var1);
        }

        public static interface ExistingWindowsPlanWithGroup {
            public WithWindowsAppFramework withExistingResourceGroup(String var1);

            public WithWindowsAppFramework withExistingResourceGroup(ResourceGroup var1);

            public WithWindowsAppFramework withNewResourceGroup(String var1);

            public WithWindowsAppFramework withNewResourceGroup();

            public WithWindowsAppFramework withNewResourceGroup(Creatable<ResourceGroup> var1);
        }

        public static interface NewAppServicePlanWithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithNewAppServicePlan> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<NewAppServicePlanWithGroup> {
            public ExistingWindowsPlanWithGroup withExistingWindowsPlan(AppServicePlan var1);

            public ExistingLinuxPlanWithGroup withExistingLinuxPlan(AppServicePlan var1);
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.NewAppServicePlanWithGroup,
    DefinitionStages.WithNewAppServicePlan,
    DefinitionStages.WithLinuxAppFramework,
    DefinitionStages.WithCredentials,
    DefinitionStages.WithStartUpCommand,
    DefinitionStages.WithWindowsAppFramework,
    DefinitionStages.WithCreate {
    }
}

