// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appservice.fluent.models.RequestHistoryInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The list of workflow request histories. */
@Fluent
public final class RequestHistoryListResult {
    /*
     * A list of workflow request histories.
     */
    @JsonProperty(value = "value")
    private List<RequestHistoryInner> value;

    /*
     * The URL to get the next set of results.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /** Creates an instance of RequestHistoryListResult class. */
    public RequestHistoryListResult() {
    }

    /**
     * Get the value property: A list of workflow request histories.
     *
     * @return the value value.
     */
    public List<RequestHistoryInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of workflow request histories.
     *
     * @param value the value value to set.
     * @return the RequestHistoryListResult object itself.
     */
    public RequestHistoryListResult withValue(List<RequestHistoryInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to get the next set of results.
     *
     * @param nextLink the nextLink value to set.
     * @return the RequestHistoryListResult object itself.
     */
    public RequestHistoryListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
