// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appservice.fluent.models.RenewCertificateOrderRequestProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Class representing certificate renew request. */
@Fluent
public final class RenewCertificateOrderRequest extends ProxyOnlyResource {
    /*
     * RenewCertificateOrderRequest resource specific properties
     */
    @JsonProperty(value = "properties")
    private RenewCertificateOrderRequestProperties innerProperties;

    /** Creates an instance of RenewCertificateOrderRequest class. */
    public RenewCertificateOrderRequest() {
    }

    /**
     * Get the innerProperties property: RenewCertificateOrderRequest resource specific properties.
     *
     * @return the innerProperties value.
     */
    private RenewCertificateOrderRequestProperties innerProperties() {
        return this.innerProperties;
    }

    /** {@inheritDoc} */
    @Override
    public RenewCertificateOrderRequest withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the keySize property: Certificate Key Size.
     *
     * @return the keySize value.
     */
    public Integer keySize() {
        return this.innerProperties() == null ? null : this.innerProperties().keySize();
    }

    /**
     * Set the keySize property: Certificate Key Size.
     *
     * @param keySize the keySize value to set.
     * @return the RenewCertificateOrderRequest object itself.
     */
    public RenewCertificateOrderRequest withKeySize(Integer keySize) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RenewCertificateOrderRequestProperties();
        }
        this.innerProperties().withKeySize(keySize);
        return this;
    }

    /**
     * Get the csr property: Csr to be used for re-key operation.
     *
     * @return the csr value.
     */
    public String csr() {
        return this.innerProperties() == null ? null : this.innerProperties().csr();
    }

    /**
     * Set the csr property: Csr to be used for re-key operation.
     *
     * @param csr the csr value to set.
     * @return the RenewCertificateOrderRequest object itself.
     */
    public RenewCertificateOrderRequest withCsr(String csr) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RenewCertificateOrderRequestProperties();
        }
        this.innerProperties().withCsr(csr);
        return this;
    }

    /**
     * Get the isPrivateKeyExternal property: Should we change the ASC type (from managed private key to external
     * private key and vice versa).
     *
     * @return the isPrivateKeyExternal value.
     */
    public Boolean isPrivateKeyExternal() {
        return this.innerProperties() == null ? null : this.innerProperties().isPrivateKeyExternal();
    }

    /**
     * Set the isPrivateKeyExternal property: Should we change the ASC type (from managed private key to external
     * private key and vice versa).
     *
     * @param isPrivateKeyExternal the isPrivateKeyExternal value to set.
     * @return the RenewCertificateOrderRequest object itself.
     */
    public RenewCertificateOrderRequest withIsPrivateKeyExternal(Boolean isPrivateKeyExternal) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RenewCertificateOrderRequestProperties();
        }
        this.innerProperties().withIsPrivateKeyExternal(isPrivateKeyExternal);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
