// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/** Whether this detector is an Analysis Detector or not. */
public enum DetectorType {
    /** Enum value Detector. */
    DETECTOR("Detector"),

    /** Enum value Analysis. */
    ANALYSIS("Analysis"),

    /** Enum value CategoryOverview. */
    CATEGORY_OVERVIEW("CategoryOverview");

    /** The actual serialized value for a DetectorType instance. */
    private final String value;

    DetectorType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a DetectorType instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed DetectorType object, or null if unable to parse.
     */
    @JsonCreator
    public static DetectorType fromString(String value) {
        if (value == null) {
            return null;
        }
        DetectorType[] items = DetectorType.values();
        for (DetectorType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /** {@inheritDoc} */
    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
