// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appservice.models.AbnormalTimePeriod;
import com.azure.resourcemanager.appservice.models.AnalysisData;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

/** DiagnosticAnalysis resource specific properties. */
@Fluent
public final class DiagnosticAnalysisProperties {
    /*
     * Start time of the period
     */
    @JsonProperty(value = "startTime")
    private OffsetDateTime startTime;

    /*
     * End time of the period
     */
    @JsonProperty(value = "endTime")
    private OffsetDateTime endTime;

    /*
     * List of time periods.
     */
    @JsonProperty(value = "abnormalTimePeriods")
    private List<AbnormalTimePeriod> abnormalTimePeriods;

    /*
     * Data by each detector
     */
    @JsonProperty(value = "payload")
    private List<AnalysisData> payload;

    /*
     * Data by each detector for detectors that did not corelate
     */
    @JsonProperty(value = "nonCorrelatedDetectors")
    private List<DetectorDefinition> nonCorrelatedDetectors;

    /** Creates an instance of DiagnosticAnalysisProperties class. */
    public DiagnosticAnalysisProperties() {
    }

    /**
     * Get the startTime property: Start time of the period.
     *
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    /**
     * Set the startTime property: Start time of the period.
     *
     * @param startTime the startTime value to set.
     * @return the DiagnosticAnalysisProperties object itself.
     */
    public DiagnosticAnalysisProperties withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the endTime property: End time of the period.
     *
     * @return the endTime value.
     */
    public OffsetDateTime endTime() {
        return this.endTime;
    }

    /**
     * Set the endTime property: End time of the period.
     *
     * @param endTime the endTime value to set.
     * @return the DiagnosticAnalysisProperties object itself.
     */
    public DiagnosticAnalysisProperties withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    /**
     * Get the abnormalTimePeriods property: List of time periods.
     *
     * @return the abnormalTimePeriods value.
     */
    public List<AbnormalTimePeriod> abnormalTimePeriods() {
        return this.abnormalTimePeriods;
    }

    /**
     * Set the abnormalTimePeriods property: List of time periods.
     *
     * @param abnormalTimePeriods the abnormalTimePeriods value to set.
     * @return the DiagnosticAnalysisProperties object itself.
     */
    public DiagnosticAnalysisProperties withAbnormalTimePeriods(List<AbnormalTimePeriod> abnormalTimePeriods) {
        this.abnormalTimePeriods = abnormalTimePeriods;
        return this;
    }

    /**
     * Get the payload property: Data by each detector.
     *
     * @return the payload value.
     */
    public List<AnalysisData> payload() {
        return this.payload;
    }

    /**
     * Set the payload property: Data by each detector.
     *
     * @param payload the payload value to set.
     * @return the DiagnosticAnalysisProperties object itself.
     */
    public DiagnosticAnalysisProperties withPayload(List<AnalysisData> payload) {
        this.payload = payload;
        return this;
    }

    /**
     * Get the nonCorrelatedDetectors property: Data by each detector for detectors that did not corelate.
     *
     * @return the nonCorrelatedDetectors value.
     */
    public List<DetectorDefinition> nonCorrelatedDetectors() {
        return this.nonCorrelatedDetectors;
    }

    /**
     * Set the nonCorrelatedDetectors property: Data by each detector for detectors that did not corelate.
     *
     * @param nonCorrelatedDetectors the nonCorrelatedDetectors value to set.
     * @return the DiagnosticAnalysisProperties object itself.
     */
    public DiagnosticAnalysisProperties withNonCorrelatedDetectors(List<DetectorDefinition> nonCorrelatedDetectors) {
        this.nonCorrelatedDetectors = nonCorrelatedDetectors;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (abnormalTimePeriods() != null) {
            abnormalTimePeriods().forEach(e -> e.validate());
        }
        if (payload() != null) {
            payload().forEach(e -> e.validate());
        }
        if (nonCorrelatedDetectors() != null) {
            nonCorrelatedDetectors().forEach(e -> e.validate());
        }
    }
}
