// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.StaticSiteDatabaseConnectionConfigurationFileOverview;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Static Site Database Connection resource. */
@Fluent
public final class DatabaseConnectionInner extends ProxyOnlyResource {
    /*
     * DatabaseConnection resource specific properties
     */
    @JsonProperty(value = "properties")
    private DatabaseConnectionProperties innerProperties;

    /** Creates an instance of DatabaseConnectionInner class. */
    public DatabaseConnectionInner() {
    }

    /**
     * Get the innerProperties property: DatabaseConnection resource specific properties.
     *
     * @return the innerProperties value.
     */
    private DatabaseConnectionProperties innerProperties() {
        return this.innerProperties;
    }

    /** {@inheritDoc} */
    @Override
    public DatabaseConnectionInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the resourceId property: The resource id of the database.
     *
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceId();
    }

    /**
     * Set the resourceId property: The resource id of the database.
     *
     * @param resourceId the resourceId value to set.
     * @return the DatabaseConnectionInner object itself.
     */
    public DatabaseConnectionInner withResourceId(String resourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseConnectionProperties();
        }
        this.innerProperties().withResourceId(resourceId);
        return this;
    }

    /**
     * Get the connectionIdentity property: If present, the identity is used in conjunction with connection string to
     * connect to the database. Use of the system-assigned managed identity is indicated with the string
     * 'SystemAssigned', while use of a user-assigned managed identity is indicated with the resource id of the managed
     * identity resource.
     *
     * @return the connectionIdentity value.
     */
    public String connectionIdentity() {
        return this.innerProperties() == null ? null : this.innerProperties().connectionIdentity();
    }

    /**
     * Set the connectionIdentity property: If present, the identity is used in conjunction with connection string to
     * connect to the database. Use of the system-assigned managed identity is indicated with the string
     * 'SystemAssigned', while use of a user-assigned managed identity is indicated with the resource id of the managed
     * identity resource.
     *
     * @param connectionIdentity the connectionIdentity value to set.
     * @return the DatabaseConnectionInner object itself.
     */
    public DatabaseConnectionInner withConnectionIdentity(String connectionIdentity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseConnectionProperties();
        }
        this.innerProperties().withConnectionIdentity(connectionIdentity);
        return this;
    }

    /**
     * Get the connectionString property: The connection string to use to connect to the database.
     *
     * @return the connectionString value.
     */
    public String connectionString() {
        return this.innerProperties() == null ? null : this.innerProperties().connectionString();
    }

    /**
     * Set the connectionString property: The connection string to use to connect to the database.
     *
     * @param connectionString the connectionString value to set.
     * @return the DatabaseConnectionInner object itself.
     */
    public DatabaseConnectionInner withConnectionString(String connectionString) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseConnectionProperties();
        }
        this.innerProperties().withConnectionString(connectionString);
        return this;
    }

    /**
     * Get the region property: The region of the database resource.
     *
     * @return the region value.
     */
    public String region() {
        return this.innerProperties() == null ? null : this.innerProperties().region();
    }

    /**
     * Set the region property: The region of the database resource.
     *
     * @param region the region value to set.
     * @return the DatabaseConnectionInner object itself.
     */
    public DatabaseConnectionInner withRegion(String region) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseConnectionProperties();
        }
        this.innerProperties().withRegion(region);
        return this;
    }

    /**
     * Get the configurationFiles property: A list of configuration files associated with this database connection.
     *
     * @return the configurationFiles value.
     */
    public List<StaticSiteDatabaseConnectionConfigurationFileOverview> configurationFiles() {
        return this.innerProperties() == null ? null : this.innerProperties().configurationFiles();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
